/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind.helpers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.bind.JAXBException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class AbstractUnmarshallerImpl
implements Unmarshaller {
    private boolean isValidating;
    private XMLReader xmlReader;
    private static SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
    private ValidationEventHandler validationEventHandler = DefaultValidationEventHandler.theInstance;
    static /* synthetic */ Class class$javax$xml$transform$Source;
    static /* synthetic */ Class class$javax$xml$transform$sax$SAXSource;
    static /* synthetic */ Class class$javax$xml$transform$stream$StreamSource;
    static /* synthetic */ Class class$javax$xml$transform$dom$DOMSource;

    protected XMLReader getXMLReader() throws JAXBException {
        if (this.xmlReader == null) {
            try {
                SAXParser sp = saxParserFactory.newSAXParser();
                this.xmlReader = sp.getXMLReader();
            }
            catch (ParserConfigurationException e) {
                throw new JAXBException("Failed to create a JAXP compliant SAX parser.", e);
            }
            catch (SAXException e) {
                throw new JAXBException("Failed to create a JAXP compliant SAX parser.", e);
            }
        }
        return this.xmlReader;
    }

    public Object unmarshal(Source pSource) throws JAXBException {
        if (pSource instanceof SAXSource) {
            SAXSource ss = (SAXSource)pSource;
            InputSource is = ss.getInputSource();
            XMLReader xr = ss.getXMLReader();
            if (xr == null) {
                xr = this.getXMLReader();
            }
            return this.unmarshal(xr, is);
        }
        if (pSource instanceof StreamSource) {
            InputSource is;
            StreamSource ss = (StreamSource)pSource;
            InputStream istream = ss.getInputStream();
            if (istream == null) {
                Reader r = ss.getReader();
                if (r == null) {
                    throw new JAXBException("The specified StreamSource must have configured either of its InputStream or Reader.");
                }
                is = new InputSource(r);
            } else {
                is = new InputSource(istream);
            }
            is.setSystemId(ss.getSystemId());
            is.setPublicId(ss.getPublicId());
            return this.unmarshal(this.getXMLReader(), is);
        }
        if (pSource instanceof DOMSource) {
            DOMSource ds = (DOMSource)pSource;
            return this.unmarshal(ds.getNode());
        }
        throw new JAXBException("Unsupported type of " + (class$javax$xml$transform$Source == null ? (class$javax$xml$transform$Source = AbstractUnmarshallerImpl.class$("javax.xml.transform.Source")) : class$javax$xml$transform$Source).getName() + ", expected either of " + (class$javax$xml$transform$sax$SAXSource == null ? (class$javax$xml$transform$sax$SAXSource = AbstractUnmarshallerImpl.class$("javax.xml.transform.sax.SAXSource")) : class$javax$xml$transform$sax$SAXSource).getName() + ", " + (class$javax$xml$transform$stream$StreamSource == null ? (class$javax$xml$transform$stream$StreamSource = AbstractUnmarshallerImpl.class$("javax.xml.transform.stream.StreamSource")) : class$javax$xml$transform$stream$StreamSource).getName() + ", or " + (class$javax$xml$transform$dom$DOMSource == null ? (class$javax$xml$transform$dom$DOMSource = AbstractUnmarshallerImpl.class$("javax.xml.transform.dom.DOMSource")) : class$javax$xml$transform$dom$DOMSource).getName());
    }

    protected abstract Object unmarshal(XMLReader var1, InputSource var2) throws JAXBException;

    public final Object unmarshal(InputSource pSource) throws JAXBException {
        return this.unmarshal(this.getXMLReader(), pSource);
    }

    public final Object unmarshal(URL pURL) throws JAXBException {
        InputSource isource;
        try {
            isource = new InputSource(pURL.openStream());
        }
        catch (IOException e) {
            throw new JAXBException("Failed to open URL " + pURL + ": " + e.getMessage(), e);
        }
        isource.setSystemId(pURL.toExternalForm());
        return this.unmarshal(this.getXMLReader(), isource);
    }

    public final Object unmarshal(File pFile) throws JAXBException {
        InputSource isource;
        try {
            isource = new InputSource(new FileInputStream(pFile));
        }
        catch (IOException e) {
            throw new JAXBException("Failed to open file " + pFile + ": " + e.getMessage(), e);
        }
        try {
            isource.setSystemId(pFile.toURL().toExternalForm());
        }
        catch (IOException e) {
            throw new JAXBException("Malformed URL: " + pFile, e);
        }
        return this.unmarshal(this.getXMLReader(), isource);
    }

    public final Object unmarshal(InputStream pSource) throws JAXBException {
        return this.unmarshal(this.getXMLReader(), new InputSource(pSource));
    }

    public boolean isValidating() throws JAXBException {
        return this.isValidating;
    }

    public void setValidating(boolean pValidating) throws JAXBException {
        this.isValidating = pValidating;
    }

    public ValidationEventHandler getEventHandler() throws JAXBException {
        return this.validationEventHandler;
    }

    public void setEventHandler(ValidationEventHandler pHandler) throws JAXBException {
        this.validationEventHandler = pHandler;
    }

    protected UnmarshalException createUnmarshalException(SAXException pException) {
        Exception ex = pException.getException();
        if (ex != null && ex instanceof UnmarshalException) {
            return (UnmarshalException)ex;
        }
        return new UnmarshalException(pException);
    }

    public void setProperty(String pName, Object pValue) throws PropertyException {
        if (pName == null) {
            throw new IllegalArgumentException("The property name must not be null.");
        }
        throw new PropertyException("Unsupported property name: " + pName);
    }

    public Object getProperty(String pName) throws PropertyException {
        if (pName == null) {
            throw new IllegalArgumentException("The property name must not be null.");
        }
        throw new PropertyException("Unsupported property name: " + pName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        saxParserFactory.setNamespaceAware(true);
        saxParserFactory.setValidating(false);
    }
}

