/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.management.loading.ClassLoaderRepository;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.RepositoryClassLoader;
import org.jboss.mx.server.ServerConstants;
import org.jboss.util.loading.Translator;

public abstract class LoaderRepository
implements ServerConstants,
ClassLoaderRepository {
    protected static Vector loaders = new Vector();
    protected static LoaderRepository instance = null;
    protected Translator translator = null;
    private ConcurrentReaderHashMap classes = new ConcurrentReaderHashMap();
    private static HashMap nativeClassBySignature;
    private static final Logger log;

    public Vector getLoaders() {
        return loaders;
    }

    public URL[] getURLs() {
        return null;
    }

    public Class getCachedClass(String classname) {
        return (Class)this.classes.get((Object)classname);
    }

    public Translator getTranslator() {
        return this.translator;
    }

    public void setTranslator(Translator t) {
        this.translator = t;
    }

    public int compare(LoaderRepository lr) {
        if (lr == this) {
            return 0;
        }
        return -lr.reverseCompare(this);
    }

    public abstract Class loadClass(String var1) throws ClassNotFoundException;

    public abstract Class loadClassWithout(ClassLoader var1, String var2) throws ClassNotFoundException;

    public abstract Class loadClassBefore(ClassLoader var1, String var2) throws ClassNotFoundException;

    public abstract RepositoryClassLoader newClassLoader(URL var1, boolean var2) throws Exception;

    public abstract RepositoryClassLoader newClassLoader(URL var1, URL var2, boolean var3) throws Exception;

    public abstract Class loadClass(String var1, boolean var2, ClassLoader var3) throws ClassNotFoundException;

    public abstract URL getResource(String var1, ClassLoader var2);

    public abstract void getResources(String var1, ClassLoader var2, List var3);

    public abstract void addClassLoader(ClassLoader var1);

    public abstract boolean addClassLoaderURL(ClassLoader var1, URL var2);

    public abstract void removeClassLoader(ClassLoader var1);

    public static final Class getNativeClassForName(String className) {
        return (Class)nativeClassBySignature.get(className);
    }

    protected int reverseCompare(LoaderRepository lr) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheLoadedClass(String name, Class cls, ClassLoader cl) {
        ConcurrentReaderHashMap concurrentReaderHashMap = this.classes;
        synchronized (concurrentReaderHashMap) {
            this.classes.put((Object)name, (Object)cls);
            if (log.isTraceEnabled()) {
                log.trace((Object)("cacheLoadedClass, classname: " + name + ", class: " + cls + ", cl: " + cl));
            }
        }
    }

    void clear() {
        this.classes.clear();
    }

    static {
        log = Logger.getLogger((Class)LoaderRepository.class);
        nativeClassBySignature = new HashMap();
        nativeClassBySignature.put("boolean", Boolean.TYPE);
        nativeClassBySignature.put("byte", Byte.TYPE);
        nativeClassBySignature.put("char", Character.TYPE);
        nativeClassBySignature.put("double", Double.TYPE);
        nativeClassBySignature.put("float", Float.TYPE);
        nativeClassBySignature.put("int", Integer.TYPE);
        nativeClassBySignature.put("long", Long.TYPE);
        nativeClassBySignature.put("short", Short.TYPE);
        nativeClassBySignature.put("void", Void.TYPE);
        nativeClassBySignature.put("boolean[]", [Z.class);
        nativeClassBySignature.put("byte[]", [B.class);
        nativeClassBySignature.put("char[]", [C.class);
        nativeClassBySignature.put("double[]", [D.class);
        nativeClassBySignature.put("float[]", [F.class);
        nativeClassBySignature.put("int[]", [I.class);
        nativeClassBySignature.put("long[]", [J.class);
        nativeClassBySignature.put("short[]", [S.class);
    }
}

