/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.PathMap;
import org.mortbay.jetty.servlet.Holder;
import org.mortbay.jetty.servlet.WebApplicationHandler;
import org.mortbay.util.LazyList;
import org.mortbay.util.TypeUtil;

public class FilterHolder
extends Holder {
    public static final int __REQUEST = 1;
    public static final int __FORWARD = 2;
    public static final int __INCLUDE = 4;
    public static final int __ERROR = 8;
    public static final int __ALL = 15;
    private PathMap _pathSpecs;
    private Map _servlets;
    private transient Filter _filter;
    private transient Config _config;
    static /* synthetic */ Class class$javax$servlet$Filter;

    public static int type(String type) {
        if ("request".equalsIgnoreCase(type)) {
            return 1;
        }
        if ("forward".equalsIgnoreCase(type)) {
            return 2;
        }
        if ("include".equalsIgnoreCase(type)) {
            return 4;
        }
        if ("error".equalsIgnoreCase(type)) {
            return 8;
        }
        throw new IllegalArgumentException(type);
    }

    public FilterHolder() {
    }

    public FilterHolder(HttpHandler httpHandler, String name, String className) {
        super(httpHandler, name, className);
    }

    public void addDispatchesToServlet(String name, String type) {
        if (this._servlets == null || !this._servlets.containsKey(name)) {
            throw new IllegalStateException();
        }
        this._servlets.put(name, TypeUtil.newInteger((Integer)this._servlets.get(name) | FilterHolder.type(type)));
    }

    public void addDispatchesToPathSpec(String pathSpec, String type) {
        if (this._pathSpecs == null || !this._pathSpecs.containsKey(pathSpec)) {
            throw new IllegalStateException();
        }
        this._pathSpecs.put(pathSpec, TypeUtil.newInteger((Integer)this._pathSpecs.get(pathSpec) | FilterHolder.type(type)));
    }

    public void addServlet(String servlet) {
        if (this._servlets == null) {
            this._servlets = new HashMap();
        }
        this._servlets.put(servlet, new Integer(0));
    }

    public void addPathSpec(String pathSpec) {
        if (this._pathSpecs == null) {
            this._pathSpecs = new PathMap(true);
        }
        this._pathSpecs.put(pathSpec, TypeUtil.newInteger(0));
    }

    public boolean isMappedToPath() {
        return this._pathSpecs != null;
    }

    public boolean appliesToPath(String path, int type) {
        if (this._pathSpecs == null) {
            return false;
        }
        Integer t = (Integer)this._pathSpecs.match(path);
        if (t == null) {
            return false;
        }
        return t == 0 && type == 1 || (t & type) != 0;
    }

    public boolean appliesToServlet(String name, int type) {
        if (this._servlets == null) {
            return false;
        }
        Integer t = (Integer)this._servlets.get(name);
        if (t == null) {
            return false;
        }
        return t == 0 && type == 1 || (t & type) != 0;
    }

    public void start() throws Exception {
        super.start();
        if (!(class$javax$servlet$Filter == null ? (class$javax$servlet$Filter = FilterHolder.class$("javax.servlet.Filter")) : class$javax$servlet$Filter).isAssignableFrom(this._class)) {
            super.stop();
            throw new IllegalStateException(this._class + " is not a javax.servlet.Filter");
        }
        this._filter = (Filter)this.newInstance();
        this._config = new Config();
        this._filter.init((FilterConfig)this._config);
    }

    public void stop() {
        if (this._filter != null) {
            this._filter.destroy();
        }
        this._filter = null;
        this._config = null;
        super.stop();
    }

    public Filter getFilter() {
        return this._filter;
    }

    public String[] getPaths() {
        if (this._pathSpecs == null) {
            return null;
        }
        int s = this._pathSpecs.keySet().size();
        return this._pathSpecs.keySet().toArray(new String[s]);
    }

    public String[] getServlets() {
        if (this._servlets == null) {
            return null;
        }
        int s = LazyList.size(this._servlets);
        return LazyList.getList(this._servlets).toArray(new String[s]);
    }

    public String toString() {
        return this.getName();
    }

    public String dump() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName());
        buf.append('[');
        buf.append(this.getClassName());
        int i = 0;
        while (i < LazyList.size(this._servlets)) {
            buf.append(',');
            buf.append(LazyList.get(this._servlets, i));
            ++i;
        }
        if (this._pathSpecs != null) {
            Iterator iter = this._pathSpecs.keySet().iterator();
            while (iter.hasNext()) {
                buf.append(',');
                buf.append(iter.next());
            }
        }
        buf.append(']');
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class Config
    implements FilterConfig {
        Config() {
        }

        public String getFilterName() {
            return FilterHolder.this.getName();
        }

        public ServletContext getServletContext() {
            return ((WebApplicationHandler)FilterHolder.this._httpHandler).getServletContext();
        }

        public String getInitParameter(String param) {
            return FilterHolder.this.getInitParameter(param);
        }

        public Enumeration getInitParameterNames() {
            return FilterHolder.this.getInitParameterNames();
        }
    }
}

