/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.log4j.Logger;
import org.jgroups.blocks.DistributedQueue;
import org.jgroups.blocks.DistributedQueuePutTask;
import org.jgroups.blocks.DistributedQueueReadTask;
import org.jgroups.blocks.ICounter;
import org.jgroups.util.Util;

public class DistributedQueueConcurrencyTest
extends TestCase
implements ICounter {
    protected static int items = 0;
    final int NUM_CLIENTS = 5;
    final int NUM_ITEMS = 10;
    final int REPEAT_TEST = 1;
    final int STATE_TRANSFER_TIMEOUT = 4000;
    static Logger logger = Logger.getLogger((String)(class$org$jgroups$blocks$DistributedQueueConcurrencyTest == null ? (class$org$jgroups$blocks$DistributedQueueConcurrencyTest = DistributedQueueConcurrencyTest.class$("org.jgroups.blocks.DistributedQueueConcurrencyTest")) : class$org$jgroups$blocks$DistributedQueueConcurrencyTest).getName());
    String props;
    protected DistributedQueue queue1;
    protected DistributedQueue queue2;
    protected DistributedQueue queue3;
    protected DistributedQueue queue;
    protected DistributedQueue queuePut;
    static /* synthetic */ Class class$org$jgroups$blocks$DistributedQueueConcurrencyTest;

    public DistributedQueueConcurrencyTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return new TestSuite(class$org$jgroups$blocks$DistributedQueueConcurrencyTest == null ? (class$org$jgroups$blocks$DistributedQueueConcurrencyTest = DistributedQueueConcurrencyTest.class$("org.jgroups.blocks.DistributedQueueConcurrencyTest")) : class$org$jgroups$blocks$DistributedQueueConcurrencyTest);
    }

    public void setUp() throws Exception {
        this.props = "UDP(mcast_recv_buf_size=80000;mcast_send_buf_size=150000;mcast_port=45566;mcast_addr=228.8.8.8;ip_ttl=32):PING(timeout=2000;num_initial_members=5):MERGE2(min_interval=5000;max_interval=10000):FD_SOCK:VERIFY_SUSPECT(timeout=1500):UNICAST(timeout=600,1200,2000,2500):FRAG(frag_size=8192;down_thread=false;up_thread=false):TOTAL_TOKEN(block_sending=50;unblock_sending=10):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=true;print_local_addr=true):STATE_TRANSFER:QUEUE";
    }

    public void tearDown() throws Exception {
    }

    public synchronized int increment() {
        return ++items;
    }

    public int getValue() {
        return items;
    }

    public void testConcurrentOneItem() throws Exception {
        logger.info((Object)"start testConcurrentOneItem");
        this.queue1 = new DistributedQueue("concurency", null, this.props, 4000L);
        Util.sleep(1000L);
        this.queue2 = new DistributedQueue("concurency", null, this.props, 4000L);
        Util.sleep(1000L);
        DistributedQueueReadTask t1 = new DistributedQueueReadTask("Queue1", this.queue1, this, 1, 5000);
        DistributedQueueReadTask t2 = new DistributedQueueReadTask("Queue2", this.queue2, this, 1, 5000);
        Thread rTask1 = new Thread(t1);
        Thread rTask2 = new Thread(t2);
        rTask1.start();
        rTask2.start();
        Util.sleep(6000L);
        this.queue3 = new DistributedQueue("concurency", null, this.props, 4000L);
        DistributedQueuePutTask t3 = new DistributedQueuePutTask("Queue3", this.queue3, 1, 0);
        Thread rTask3 = new Thread(t3);
        rTask3.start();
        while (!t3.finished()) {
            Util.sleep(1000L);
        }
        while (!t1.finished() && !t2.finished()) {
            Util.sleep(1000L);
        }
        DistributedQueueConcurrencyTest.assertEquals((int)0, (int)this.queue1.size());
        DistributedQueueConcurrencyTest.assertEquals((int)0, (int)this.queue2.size());
        DistributedQueueConcurrencyTest.assertEquals((int)0, (int)this.queue3.size());
        int total = t1.getContent().size() + t2.getContent().size();
        DistributedQueueConcurrencyTest.assertEquals((int)1, (int)total);
        DistributedQueueConcurrencyTest.assertEquals((int)1, (int)t3.getContent().size());
        Vector totalContent = t1.getContent();
        totalContent.addAll(t2.getContent());
        this.checkContents(t3.getContent(), totalContent);
        this.queue3.stop();
        this.queue1.stop();
        this.queue2.stop();
        Util.sleep(1000L);
        logger.info((Object)"end testConcurrentOneItem");
    }

    public void testConcurrentMultipleItems() throws Exception {
        for (int i = 0; i < 1; ++i) {
            this._concurrentMultipleItems(i);
        }
    }

    protected void _concurrentMultipleItems(int i) throws Exception {
        logger.info((Object)("start testConcurrentMultipleItems " + i + " run"));
        this.queue1 = new DistributedQueue("concurency", null, this.props, 4000L);
        Util.sleep(1000L);
        this.queue2 = new DistributedQueue("concurency", null, this.props, 4000L);
        Util.sleep(1000L);
        items = 0;
        DistributedQueueReadTask t1 = new DistributedQueueReadTask("Queue1", this.queue1, this, 10, 5000);
        DistributedQueueReadTask t2 = new DistributedQueueReadTask("Queue2", this.queue2, this, 10, 5000);
        Thread rTask1 = new Thread(t1);
        Thread rTask2 = new Thread(t2);
        rTask1.start();
        rTask2.start();
        Util.sleep(6000L);
        this.queue3 = new DistributedQueue("concurency", null, this.props, 4000L);
        DistributedQueuePutTask t3 = new DistributedQueuePutTask("Queue3", this.queue3, 10, 6000);
        Thread rTask3 = new Thread(t3);
        rTask3.start();
        while (!t3.finished()) {
            Util.sleep(1000L);
        }
        while (!t1.finished() || !t2.finished()) {
            Util.sleep(1000L);
        }
        if (this.queue1.size() > 0) {
            logger.debug((Object)("Queue1:" + this.queue1.toString()));
        }
        if (this.queue2.size() > 0) {
            logger.debug((Object)("Queue2:" + this.queue2.toString()));
        }
        if (this.queue3.size() > 0) {
            logger.debug((Object)("Queue3:" + this.queue3.toString()));
        }
        DistributedQueueConcurrencyTest.assertEquals((int)0, (int)this.queue1.size());
        DistributedQueueConcurrencyTest.assertEquals((int)0, (int)this.queue2.size());
        DistributedQueueConcurrencyTest.assertEquals((int)0, (int)this.queue3.size());
        int total = t1.getContent().size() + t2.getContent().size();
        DistributedQueueConcurrencyTest.assertEquals((int)10, (int)total);
        DistributedQueueConcurrencyTest.assertEquals((int)10, (int)t3.getContent().size());
        Vector totalContent = t1.getContent();
        totalContent.addAll(t2.getContent());
        this.checkContents(t3.getContent(), totalContent);
        this.queue3.stop();
        this.queue3 = null;
        this.queue1.stop();
        this.queue2.stop();
        Util.sleep(1000L);
        logger.info((Object)"end testConcurrentMultipleItems");
    }

    protected void checkContents(Vector q1, Vector q2) {
        DistributedQueueConcurrencyTest.assertEquals((int)q1.size(), (int)q2.size());
        DistributedQueueConcurrencyTest.assertTrue((boolean)q1.containsAll(q2));
        DistributedQueueConcurrencyTest.assertTrue((boolean)q2.containsAll(q1));
    }

    public void testMultipleReaderOneWriter() throws Exception {
        int i;
        logger.info((Object)"start testMultipleReaderOneWriter");
        items = 0;
        Vector<DistributedQueue> queues = new Vector<DistributedQueue>();
        for (int i2 = 0; i2 < 5; ++i2) {
            this.queue = new DistributedQueue("crashme", null, this.props, 4000L);
            Util.sleep(500L);
            queues.add(this.queue);
        }
        Vector<DistributedQueueReadTask> vTask = new Vector<DistributedQueueReadTask>();
        for (int i3 = 0; i3 < 5; ++i3) {
            this.queue = (DistributedQueue)queues.elementAt(i3);
            DistributedQueueReadTask t = new DistributedQueueReadTask("Queue" + i3, this.queue, this, 10, 5000);
            vTask.add(t);
            Thread task = new Thread(t);
            task.start();
            Util.sleep(500L);
        }
        this.queuePut = new DistributedQueue("crashme", null, this.props, 4000L);
        Util.sleep(1000L);
        DistributedQueuePutTask putTask = new DistributedQueuePutTask("PutQueue", this.queuePut, 10, 200);
        Thread rTask3 = new Thread(putTask);
        rTask3.start();
        while (!putTask.finished()) {
            Util.sleep(1000L);
        }
        boolean finished = false;
        while (!finished) {
            finished = true;
            for (int i4 = 0; i4 < 5; ++i4) {
                DistributedQueueReadTask reader = (DistributedQueueReadTask)vTask.elementAt(i4);
                if (reader.finished()) continue;
                finished = false;
                break;
            }
            Util.sleep(1000L);
        }
        Vector totalContent = new Vector();
        for (i = 0; i < 5; ++i) {
            this.queue = (DistributedQueue)queues.elementAt(i);
            DistributedQueueConcurrencyTest.assertEquals((int)0, (int)this.queue.size());
            DistributedQueueReadTask t = (DistributedQueueReadTask)vTask.elementAt(i);
            totalContent.addAll(t.getContent());
            logger.debug((Object)("New total:" + totalContent.size()));
        }
        DistributedQueueConcurrencyTest.assertEquals((int)0, (int)this.queuePut.size());
        DistributedQueueConcurrencyTest.assertEquals((int)10, (int)totalContent.size());
        DistributedQueueConcurrencyTest.assertEquals((int)10, (int)putTask.getContent().size());
        this.checkContents(putTask.getContent(), totalContent);
        this.queuePut.stop();
        for (i = 0; i < 5; ++i) {
            this.queue = (DistributedQueue)queues.elementAt(i);
            this.queue.stop();
        }
        logger.info((Object)"end testMultipleReaderOneWriter");
    }

    public void testMultipleWriterOneReader() throws Exception {
        int i;
        logger.info((Object)"start testMultipleWriterOneReader");
        items = 0;
        Vector<DistributedQueue> queues = new Vector<DistributedQueue>();
        for (int i2 = 0; i2 < 5; ++i2) {
            this.queue = new DistributedQueue("crashme", null, this.props, 4000L);
            Util.sleep(500L);
            queues.add(this.queue);
        }
        Vector<DistributedQueuePutTask> vTask = new Vector<DistributedQueuePutTask>();
        for (int i3 = 0; i3 < 5; ++i3) {
            this.queue = (DistributedQueue)queues.elementAt(i3);
            DistributedQueuePutTask t = new DistributedQueuePutTask("PutQueue" + i3, this.queue, 10, 1000);
            vTask.add(t);
            Thread task = new Thread(t);
            task.start();
            Util.sleep(500L);
        }
        this.queuePut = new DistributedQueue("crashme", null, this.props, 4000L);
        Util.sleep(1000L);
        DistributedQueueReadTask readerTask = new DistributedQueueReadTask("ReaderQueue", this.queuePut, this, 50, 1000);
        Thread rTask3 = new Thread(readerTask);
        rTask3.start();
        while (!readerTask.finished()) {
            Util.sleep(1000L);
        }
        boolean finished = false;
        while (!finished) {
            finished = true;
            for (int i4 = 0; i4 < 5; ++i4) {
                DistributedQueuePutTask reader = (DistributedQueuePutTask)vTask.elementAt(i4);
                if (reader.finished()) continue;
                finished = false;
                break;
            }
            Util.sleep(1000L);
        }
        Vector totalContent = new Vector();
        for (i = 0; i < 5; ++i) {
            this.queue = (DistributedQueue)queues.elementAt(i);
            DistributedQueueConcurrencyTest.assertEquals((int)0, (int)this.queue.size());
            DistributedQueuePutTask t = (DistributedQueuePutTask)vTask.elementAt(i);
            totalContent.addAll(t.getContent());
            logger.debug((Object)("New total:" + totalContent.size()));
        }
        DistributedQueueConcurrencyTest.assertEquals((int)0, (int)this.queuePut.size());
        DistributedQueueConcurrencyTest.assertEquals((int)50, (int)totalContent.size());
        DistributedQueueConcurrencyTest.assertEquals((int)50, (int)readerTask.getContent().size());
        this.checkContents(readerTask.getContent(), totalContent);
        this.queuePut.stop();
        for (i = 0; i < 5; ++i) {
            this.queue = (DistributedQueue)queues.elementAt(i);
            this.queue.stop();
        }
        logger.info((Object)"end testMultipleWriterOneReader");
    }

    public static void main(String[] args) {
        TestRunner.run((Test)DistributedQueueConcurrencyTest.suite());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

