/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.ensemble;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.jgroups.ensemble.Hot_Buffer;
import org.jgroups.ensemble.Hot_Endpoint;
import org.jgroups.ensemble.Hot_Ensemble;
import org.jgroups.ensemble.Hot_Error;
import org.jgroups.ensemble.Hot_Message;

class Hot_IO_Controller {
    private BufferedInputStream is;
    private OutputStream os;
    private boolean usingChecksum;
    private boolean print = false;
    public final int DN_JOIN = 0;
    public final int DN_CAST = 1;
    public final int DN_SEND = 2;
    public final int DN_SUSPECT = 3;
    public final int DN_PROTOCOL = 4;
    public final int DN_PROPERTIES = 5;
    public final int DN_LEAVE = 6;
    public final int DN_PROMPT = 7;
    public final int DN_BLOCK_ON = 8;
    public final int CB_VIEW = 0;
    public final int CB_CAST = 1;
    public final int CB_SEND = 2;
    public final int CB_HEARTBEAT = 3;
    public final int CB_BLOCK = 4;
    public final int CB_EXIT = 5;
    private int HOT_MAGIC = 365718590;
    public final int INT_SIZE = 4;
    int w_error;
    int r_error;

    public Hot_IO_Controller(BufferedInputStream is, OutputStream os) {
        this.HOT_MAGIC *= 10;
        this.HOT_MAGIC += 9;
        this.is = is;
        this.os = os;
        this.w_error = 0;
        this.r_error = 0;
        this.usingChecksum = false;
    }

    public Hot_Error check_write_errors() {
        if (this.w_error != 0) {
            this.w_error = 0;
            return new Hot_Error(0, "HOT: write failed");
        }
        return null;
    }

    public Hot_Error check_read_errors() {
        if (this.r_error != 0) {
            this.r_error = 0;
            return new Hot_Error(0, "HOT: read failed");
        }
        return null;
    }

    public void write_checksum(int checksum) {
        if (this.usingChecksum) {
            int u = checksum ^ this.HOT_MAGIC;
            if (this.w_error != 0) {
                return;
            }
            byte[] pBytes = new byte[4];
            try {
                for (int i = 3; i >= 0; --i) {
                    pBytes[i] = (byte)u;
                    u >>= 8;
                }
                this.os.write(pBytes);
                this.os.flush();
            }
            catch (Exception e) {
                this.w_error = 1;
                e.printStackTrace();
            }
        }
    }

    public void write_uint(int[] checksum, int u) {
        int holder = u;
        if (this.w_error != 0) {
            return;
        }
        byte[] pBytes = new byte[4];
        try {
            for (int i = 3; i >= 0; --i) {
                pBytes[i] = (byte)u;
                u >>= 8;
            }
            this.os.write(pBytes);
            this.os.flush();
            Hot_Ensemble.trace("write_uint: wrote " + holder);
            try {
                checksum[0] = checksum[0] + 4;
            }
            catch (Exception e) {
                System.err.println("Hot_IO_Controller::write_uint: no checksum passed in");
            }
        }
        catch (Exception e) {
            this.w_error = 1;
            e.printStackTrace();
        }
    }

    public void write_bool(int[] checksum, boolean b) {
        if (this.w_error != 0) {
            return;
        }
        this.write_uint(checksum, b ? 1 : 0);
    }

    public void write_buffer(int[] checksum, Hot_Buffer b) {
        byte[] pBytes = b.getBytes();
        this.write_actual_buffer(checksum, pBytes);
    }

    public void write_actual_buffer(int[] checksum, byte[] pBytes) {
        byte[] padBytes = new byte[4];
        if (this.w_error != 0) {
            return;
        }
        int l = pBytes.length;
        int padSize = 4 - l % 4;
        if (padSize == 4) {
            padSize = 0;
        }
        this.write_uint(checksum, l);
        if (this.w_error != 0) {
            return;
        }
        try {
            Hot_Ensemble.trace("Buffer: length = " + l + " pad = " + padSize);
            Hot_Ensemble.trace("Buffer: sent: " + new String(pBytes));
            this.os.write(pBytes);
            this.os.flush();
            if (padSize > 0 && padSize < 4) {
                this.os.write(padBytes, 0, padSize);
                this.os.flush();
            }
            try {
                checksum[0] = checksum[0] + (l + padSize);
            }
            catch (Exception e) {
                System.err.println("Hot_IO_Controller::write_buffer: no checksum passed in");
            }
        }
        catch (Exception e) {
            this.w_error = 1;
            e.printStackTrace();
        }
    }

    public void write_string(int[] checksum, String s) {
        byte[] pBytes = s.getBytes();
        this.write_actual_buffer(checksum, pBytes);
    }

    public void write_endpID(int[] checksum, Hot_Endpoint epid) {
        this.write_string(checksum, epid.name);
    }

    public void write_groupID(int[] checksum, int gid) {
        this.write_uint(checksum, gid);
    }

    public void write_msg(int[] checksum, Hot_Message msg) {
        if (this.w_error != 0) {
            return;
        }
        int[] pInt = new int[1];
        byte[] pBytes = msg.getBytes();
        int l = pBytes.length;
        byte nPadding = (byte)(4 - l % 4);
        byte[] padBytes = new byte[4];
        this.write_uint(checksum, l + nPadding);
        if (this.w_error != 0) {
            Hot_Ensemble.panic("write_msg: error writing msg length");
        }
        try {
            Hot_Ensemble.trace("Msg: sending: " + new String(pBytes));
            Hot_Ensemble.trace("Msg: length = " + l + " pad = " + nPadding);
            if (nPadding != 0) {
                padBytes[0] = nPadding;
                this.os.write(padBytes, 0, nPadding);
                this.os.flush();
            }
            this.os.write(pBytes);
            this.os.flush();
            try {
                checksum[0] = checksum[0] + 4;
            }
            catch (Exception e) {
                System.err.println("Hot_IO_Controller::write_msg: no checksum passed in");
            }
        }
        catch (Exception e) {
            this.w_error = 1;
            e.printStackTrace();
        }
    }

    public void write_endpList(int[] checksum, Hot_Endpoint[] epids) {
        if (this.w_error != 0) {
            return;
        }
        int l = epids.length;
        this.write_uint(checksum, l);
        for (int i = 0; i < l; ++i) {
            this.write_endpID(checksum, epids[i]);
        }
    }

    public void write_dnType(int[] checksum, int type) {
        if (this.w_error != 0) {
            return;
        }
        this.write_uint(checksum, type);
    }

    private void writeToStream(OutputStream out, byte[] buf) {
        int MAX_SIZE = 128;
        int len = buf.length;
        int bytes_to_write = 0;
        try {
            if (len < MAX_SIZE) {
                out.write(buf);
                return;
            }
            for (int written = 0; written < len; written += bytes_to_write) {
                bytes_to_write = len - written > MAX_SIZE ? MAX_SIZE : len - written;
                out.write(buf, written, bytes_to_write);
            }
            out.flush();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    private int readIntoBuffer(InputStream is, byte[] buf) {
        int actual_length = buf.length;
        int tmp = 0;
        int numbytes = 0;
        try {
            while ((tmp = is.read(buf, numbytes, actual_length - numbytes)) != -1 && (numbytes += tmp) < actual_length) {
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
        return numbytes;
    }

    public void read_checksum(int checksum) {
        if (this.usingChecksum) {
            if (this.r_error != 0) {
                return;
            }
            try {
                byte[] pBytes = new byte[4];
                this.is.read(pBytes);
                int tmpInt = pBytes[0];
                for (int i = 1; i < 4; ++i) {
                    tmpInt <<= 8;
                    tmpInt |= pBytes[i];
                }
                if ((tmpInt ^ this.HOT_MAGIC) != checksum) {
                    Hot_Ensemble.panic("read_checksum: " + (tmpInt ^ this.HOT_MAGIC) + " (expected " + checksum + ')');
                }
            }
            catch (Exception e) {
                this.r_error = 1;
                e.printStackTrace();
            }
        }
    }

    public void read_uint(int[] checksum, int[] u) {
        if (this.r_error != 0) {
            System.err.println("read_uint: there was a read eror !");
            return;
        }
        try {
            int i;
            byte[] pBytes = new byte[4];
            for (i = 0; i < pBytes.length; ++i) {
                pBytes[i] = 0;
            }
            this.is.read(pBytes);
            if (this.print) {
                System.out.print("\nread_uint: bytes read are ");
                for (i = 0; i < pBytes.length; ++i) {
                    System.out.print(pBytes[i] + " ");
                }
                System.out.println("");
            }
            Hot_Ensemble.trace("Bytes::" + pBytes[0] + ' ' + pBytes[1] + ' ' + pBytes[2] + ' ' + pBytes[3]);
            int tmpInt = 0;
            int b1 = pBytes[0];
            int b2 = pBytes[1];
            int b3 = pBytes[2];
            int b4 = pBytes[3];
            if (b1 < 0) {
                b1 = 256 + b1;
            }
            if (b2 < 0) {
                b2 = 256 + b2;
            }
            if (b3 < 0) {
                b3 = 256 + b3;
            }
            if (b4 < 0) {
                b4 = 256 + b4;
            }
            u[0] = tmpInt = (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
            if (this.print) {
                System.out.println("tmpInt is " + u[0]);
            }
            try {
                checksum[0] = checksum[0] + 4;
            }
            catch (Exception e) {
                System.err.println("Hot_IO_Controller::read_uint: no checksum passed in");
            }
            Hot_Ensemble.trace("read_uint: " + u[0]);
        }
        catch (Exception e) {
            this.r_error = 1;
            e.printStackTrace();
        }
    }

    public void read_bool(int[] checksum, boolean[] b) {
        if (this.r_error != 0) {
            return;
        }
        int[] anInt = new int[1];
        this.read_uint(checksum, anInt);
        b[0] = anInt[0] == 1;
    }

    public void read_buffer(int[] checksum, Hot_Buffer b) {
        if (this.r_error != 0) {
            return;
        }
        int[] bufSize = new int[1];
        this.read_uint(checksum, bufSize);
        if (this.r_error != 0) {
            return;
        }
        byte[] pBytes = new byte[bufSize[0]];
        byte[] padBytes = new byte[4];
        try {
            this.readIntoBuffer(this.is, pBytes);
            Hot_Ensemble.trace("read_buffer: read in bytes: " + pBytes.length);
            b.setBytes(pBytes);
            int padSize = 4 - bufSize[0] % 4;
            if (padSize == 4) {
                padSize = 0;
            }
            if (padSize > 0 && padSize < 4) {
                this.is.read(padBytes, 0, padSize);
                Hot_Ensemble.trace("read_buffer: read in buffer bytes: " + padSize);
            }
            try {
                checksum[0] = checksum[0] + (bufSize[0] + bufSize[0] % 4);
            }
            catch (Exception e) {
                System.err.println("Hot_IO_Controller::read_buffer: no checksum passed in");
            }
        }
        catch (Exception e) {
            this.r_error = 1;
            System.err.println("Hot_IO_Controller::read_buffer: reading: " + e.toString());
            e.printStackTrace();
        }
    }

    public void read_string(int[] checksum, String[] sb) {
        if (this.r_error != 0) {
            return;
        }
        Hot_Buffer hb = new Hot_Buffer();
        this.read_buffer(checksum, hb);
        hb.toAsciiString(sb);
    }

    public void read_endpID(int[] checksum, Hot_Endpoint epid) {
        if (this.r_error != 0) {
            return;
        }
        String[] pString = new String[1];
        this.read_string(checksum, pString);
        if (this.r_error != 0) {
            return;
        }
        epid.name = pString[0];
    }

    public void read_groupID(int[] checksum, int[] gid) {
        if (this.r_error != 0) {
            return;
        }
        this.read_uint(checksum, gid);
    }

    public void read_msg(int[] checksum, Hot_Message msg) {
        if (this.r_error != 0) {
            return;
        }
        int[] msgSize = new int[1];
        int numbytes = 0;
        this.print = true;
        this.read_uint(checksum, msgSize);
        this.print = false;
        if (this.r_error != 0) {
            System.err.println("read_msg: read error !");
            return;
        }
        try {
            byte[] pad = new byte[4];
            this.is.read(pad, 0, 1);
            byte npad = pad[0];
            if (npad <= 0 || npad >= 5) {
                Hot_Ensemble.panic("error in padding of read_msg");
            }
            if (npad > 1) {
                this.is.read(pad, 0, npad - 1);
            }
            int len = msgSize[0] - npad;
            byte[] pBytes = new byte[msgSize[0] - npad];
            int avail = this.is.available();
            numbytes = this.readIntoBuffer(this.is, pBytes);
            if (numbytes == -1) {
                System.err.println("read_msg received -1 bytes !");
                System.exit(-1);
            }
            if (numbytes != len) {
                System.err.println("Wanted to read " + len + " bytes, but read " + numbytes + " bytes");
                System.exit(-1);
            }
            msg.setBytes(pBytes);
            try {
                checksum[0] = checksum[0] + (msgSize[0] + npad);
            }
            catch (Exception e) {
                System.err.println("Hot_IO_Controller::read_msg: no checksum passed in");
            }
        }
        catch (Exception e) {
            this.r_error = 1;
            System.err.println("Hot_IO_Controller::read_msg: reading: " + e.toString());
            e.printStackTrace();
        }
    }

    public Hot_Endpoint[] read_endpList(int[] checksum, int[] size) {
        Hot_Endpoint[] rtnVal = null;
        if (this.r_error != 0) {
            return rtnVal;
        }
        this.read_uint(checksum, size);
        if (this.r_error != 0) {
            return rtnVal;
        }
        rtnVal = new Hot_Endpoint[size[0]];
        for (int i = 0; i < size[0]; ++i) {
            rtnVal[i] = new Hot_Endpoint();
            this.read_endpID(checksum, rtnVal[i]);
            if (this.r_error == 0) continue;
            Hot_Ensemble.trace("Hot_IO_Controller::read_endpList: error in read_endpID");
            return null;
        }
        return rtnVal;
    }

    public boolean[] read_boolList(int[] checksum) {
        if (this.r_error != 0) {
            return null;
        }
        int[] numBools = new int[1];
        this.read_uint(checksum, numBools);
        boolean[] rtnVal = new boolean[numBools[0]];
        if (this.r_error != 0) {
            return null;
        }
        boolean[] b = new boolean[1];
        for (int i = 0; i < numBools[0]; ++i) {
            this.read_bool(checksum, b);
            if (this.r_error != 0) {
                Hot_Ensemble.trace("Hot_IO_Controller::read_boolList: error in read_bool");
                return null;
            }
            rtnVal[i] = b[0];
        }
        return rtnVal;
    }

    public void read_cbType(int[] checksum, int[] type) {
        type[0] = 0;
        if (this.r_error != 0) {
            System.out.println("read_cbType: there was a read error !");
            return;
        }
        this.read_uint(checksum, type);
    }
}

