/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.stack.Protocol;
import org.jgroups.util.QueueClosedException;

public class ENCRYPT
extends Protocol {
    Address local_addr = null;
    Address keyServerAddr = null;
    boolean keyServer = false;
    String asymProvider = null;
    String symProvider = null;
    String asymAlgorithm = "RSA";
    String symAlgorithm = "Blowfish";
    int asymInit = 512;
    int symInit = 56;
    private boolean suppliedKey = false;
    private String keyStoreName;
    private String storePassword = "changeit";
    private String keyPassword = "changeit";
    private String alias = "mykey";
    KeyPair Kpair;
    PublicKey serverPubKey = null;
    Cipher symEncodingCipher;
    Cipher symDecodingCipher;
    private String symVersion = null;
    SecretKey secretKey = null;
    Map keyMap = new WeakHashMap();
    final Object downLock = new Object();
    final Object upLock = new Object();
    private LinkedQueue upMessageQueue = new LinkedQueue();
    private boolean queue_up = true;
    private LinkedQueue downMessageQueue = new LinkedQueue();
    private boolean queue_down = true;
    private Cipher asymCipher;

    public String getName() {
        return "ENCRYPT";
    }

    private String getAlgorithm(String s) {
        int index = s.indexOf("/");
        if (index == -1) {
            return s;
        }
        return s.substring(0, index);
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("asym_init");
        if (str != null) {
            this.asymInit = new Integer(str);
            props.remove("asym_init");
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Asym algo bits used is " + this.asymInit));
            }
        }
        if ((str = props.getProperty("sym_init")) != null) {
            this.symInit = new Integer(str);
            props.remove("sym_init");
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Sym algo bits used is " + this.symInit));
            }
        }
        if ((str = props.getProperty("asym_algorithm")) != null) {
            this.asymAlgorithm = new String(str).toString();
            props.remove("asym_algorithm");
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Asym algo used is " + this.asymAlgorithm));
            }
        }
        if ((str = props.getProperty("sym_algorithm")) != null) {
            this.symAlgorithm = new String(str).toString();
            props.remove("sym_algorithm");
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Sym algo used is " + this.symAlgorithm));
            }
        }
        if ((str = props.getProperty("asym_provider")) != null) {
            this.asymProvider = new String(str).toString();
            props.remove("asym_provider");
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("asymProvider used is " + this.asymProvider));
            }
        }
        if ((str = props.getProperty("key_store_name")) != null) {
            this.keyStoreName = new String(str).toString();
            props.remove("key_store_name");
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("key_store_name used is " + this.keyStoreName));
            }
        }
        if ((str = props.getProperty("store_password")) != null) {
            this.storePassword = new String(str).toString();
            props.remove("store_password");
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)"store_password used is not null");
            }
        }
        if ((str = props.getProperty("key_password")) != null) {
            this.keyPassword = new String(str).toString();
            props.remove("key_password");
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)"key_password used is not null");
            }
        } else if (this.storePassword != null) {
            this.keyPassword = this.storePassword;
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)"key_password used is same as store_password");
            }
        }
        if ((str = props.getProperty("alias")) != null) {
            this.alias = new String(str).toString();
            props.remove("alias");
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("alias used is " + this.alias));
            }
        }
        if (props.size() > 0) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("these properties are not recognized:" + props));
            }
            return false;
        }
        return true;
    }

    public void init() throws Exception {
        if (this.keyStoreName == null) {
            this.initSymKey();
            this.initKeyPair();
        } else {
            this.initConfiguredKey();
        }
        this.initSymCiphers(this.symAlgorithm, this.getSecretKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConfiguredKey() throws KeyStoreException, Exception, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        InputStream inputStream = null;
        KeyStore store = KeyStore.getInstance("JCEKS");
        SecretKey tempKey = null;
        try {
            inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.keyStoreName);
            if (inputStream == null) {
                throw new Exception("Unable to load keystore " + this.keyStoreName + " ensure file is on classpath");
            }
            try {
                store.load(inputStream, this.storePassword.toCharArray());
                tempKey = (SecretKey)store.getKey(this.alias, this.keyPassword.toCharArray());
            }
            catch (IOException e) {
                throw new Exception("Unable to load keystore " + this.keyStoreName, e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new Exception("No Such algorithm " + this.keyStoreName, e);
            }
            catch (CertificateException e) {
                throw new Exception("Certificate exception " + this.keyStoreName, e);
            }
            if (tempKey == null) {
                throw new Exception("Unable to retrieve key '" + this.alias + "' from keystore " + this.keyStoreName);
            }
            this.setSecretKey(tempKey);
            this.symAlgorithm = tempKey.getAlgorithm();
            this.suppliedKey = true;
            this.queue_down = false;
            this.queue_up = false;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception e) {}
        }
    }

    public void initSymKey() throws Exception {
        KeyGenerator keyGen = null;
        keyGen = this.symProvider != null && this.symProvider.trim().length() > 0 ? KeyGenerator.getInstance(this.getAlgorithm(this.symAlgorithm), this.symProvider) : KeyGenerator.getInstance(this.getAlgorithm(this.symAlgorithm));
        keyGen.init(this.symInit);
        this.secretKey = keyGen.generateKey();
        this.setSecretKey(this.secretKey);
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)" Symmetric key generated ");
        }
    }

    private void initSymCiphers(String algorithm, SecretKey secret) throws Exception {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)" Initializing symmetric ciphers");
        }
        this.symEncodingCipher = Cipher.getInstance(algorithm);
        this.symDecodingCipher = Cipher.getInstance(algorithm);
        this.symEncodingCipher.init(1, secret);
        this.symDecodingCipher.init(2, secret);
        MessageDigest digest = MessageDigest.getInstance("MD5");
        digest.reset();
        digest.update(secret.getEncoded());
        this.symVersion = new String(digest.digest());
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)(" Initialized symmetric ciphers with secret key version " + this.symVersion));
        }
    }

    public void initKeyPair() throws Exception {
        KeyPairGenerator KpairGen = null;
        KpairGen = this.asymProvider != null && this.asymProvider.trim().length() > 0 ? KeyPairGenerator.getInstance(this.getAlgorithm(this.asymAlgorithm), this.asymProvider) : KeyPairGenerator.getInstance(this.getAlgorithm(this.asymAlgorithm));
        KpairGen.initialize(this.asymInit, new SecureRandom());
        this.Kpair = KpairGen.generateKeyPair();
        this.asymCipher = Cipher.getInstance(this.asymAlgorithm);
        this.asymCipher.init(2, this.Kpair.getPrivate());
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)" asym algo initialized");
        }
    }

    public void reset() {
    }

    public void up(Event evt) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Event going up is " + evt));
        }
        switch (evt.getType()) {
            case 8: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Set local address ");
                }
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 13: {
                if (this.suppliedKey) break;
                if (!this.keyServer) {
                    if (!this.log.isInfoEnabled()) break;
                    this.log.info((Object)"FIND_INIT_MBRS_OK called - I am not the keyserver");
                    break;
                }
                if (!this.log.isInfoEnabled()) break;
                this.log.info((Object)"FIND_INIT_MBRS_OK called -I am keyserver ");
                break;
            }
            case 6: {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)"handling view change event");
                }
                if (this.suppliedKey) break;
                this.handleViewChange(evt);
                break;
            }
            case 1: {
                if (evt.getArg() == null || ((Message)evt.getArg()).getBuffer() == null) {
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug((Object)"passing up message as is empty buffer ");
                    break;
                }
                try {
                    this.handleUpMessage(evt);
                }
                catch (Exception e) {
                    this.log.warn((Object)"Exception occurred decrypting up message", (Throwable)e);
                }
                return;
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("passing event up " + evt));
        }
        this.passUp(evt);
    }

    private synchronized void handleViewChange(Event evt) {
        View view = (View)evt.getArg();
        if (view.getMembers() == null || view.getMembers().get(0) == null) {
            this.becomeKeyServer(this.local_addr);
            return;
        }
        Address tmpKeyServer = (Address)view.getMembers().get(0);
        if (tmpKeyServer.equals(this.local_addr) && (this.keyServerAddr == null || !tmpKeyServer.equals(this.keyServerAddr))) {
            this.becomeKeyServer(tmpKeyServer);
        } else if (this.keyServerAddr == null || !tmpKeyServer.equals(this.keyServerAddr)) {
            this.handleNewKeyServer(tmpKeyServer);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Membership has changed but I do not care");
        }
    }

    private void becomeKeyServer(Address tmpKeyServer) {
        this.keyServerAddr = tmpKeyServer;
        this.keyServer = true;
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)"I have become key server");
        }
        this.queue_down = false;
        this.queue_up = false;
    }

    private void handleNewKeyServer(Address newKeyServer) {
        this.queue_up = true;
        this.queue_down = true;
        this.keyServerAddr = newKeyServer;
        this.keyServer = false;
        this.log.info((Object)"Sending key request");
        this.sendKeyRequest();
    }

    private void handleUpMessage(Event evt) throws Exception {
        Message msg;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Handling up message " + evt));
        }
        if ((msg = (Message)evt.getArg()) == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Null message - passing straight up");
            }
            this.passUp(evt);
            return;
        }
        Header obj = msg.getHeader("encrypt");
        if (obj == null || !(obj instanceof EncryptHeader)) {
            if (this.log.isDebugEnabled()) {
                this.log.info((Object)"Dropping message as ENCRYPT header is null  or has not been recognized, msg will not be passed up");
            }
            return;
        }
        EncryptHeader hdr = (EncryptHeader)obj;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Header received " + hdr));
        }
        if (hdr.getType() == 0) {
            if (this.queue_up) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"queueing up message as no session key established");
                }
                this.up_queue.add(evt);
            } else {
                if (!this.suppliedKey) {
                    this.drainUpQueue();
                }
                this.decryptMessage(this.symDecodingCipher, msg);
                this.passUp(evt);
            }
        } else if (this.suppliedKey) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("We received an encrypt header of " + hdr.getType() + " while in configured mode"));
            }
        } else {
            switch (hdr.getType()) {
                case 1: {
                    this.log.info((Object)"received a key request from peer");
                    try {
                        PublicKey tmpKey = this.generatePubKey(msg.getBuffer());
                        this.sendSecretKey(this.getSecretKey(), tmpKey, msg.getSrc());
                    }
                    catch (Exception e) {
                        this.log.warn((Object)"unable to reconstitute peer's public key");
                    }
                    break;
                }
                case 3: {
                    this.log.info((Object)"received a secretkey response from keyserver");
                    try {
                        SecretKeySpec tmp = this.decodeKey(msg.getBuffer());
                        if (tmp == null) {
                            this.sendKeyRequest();
                            break;
                        }
                        this.setKeys(tmp, hdr.getVersion());
                        this.log.info((Object)"Decoded secretkey response");
                    }
                    catch (Exception e) {
                        this.log.warn((Object)"unable to process received public key");
                        this.log.fatal((Object)e);
                    }
                    break;
                }
                default: {
                    this.log.warn((Object)("Received ignored encrypt header of " + hdr.getType()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drainUpQueue() throws QueueClosedException, Exception {
        Object object = this.upLock;
        synchronized (object) {
            while (this.up_queue.size() != 0) {
                Event tmp = (Event)this.up_queue.remove();
                Message msg = this.decryptMessage(this.symDecodingCipher, (Message)tmp.getArg());
                if (msg == null) continue;
                this.passUp(tmp);
            }
        }
    }

    private void setKeys(SecretKey key, String version) throws Exception {
        this.keyMap.put(this.getSymVersion(), this.getSymDecodingCipher());
        this.setSecretKey(key);
        this.initSymCiphers(key.getAlgorithm(), key);
        this.setSymVersion(version);
        this.queue_up = false;
        this.drainUpQueue();
        this.queue_down = false;
        this.drainDownQueue();
    }

    private Message decryptMessage(Cipher cipher, Message msg) throws Exception {
        EncryptHeader hdr;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(" Starting to decypher message:" + this.formatArray(msg.getBuffer())));
        }
        if (!(hdr = (EncryptHeader)msg.getHeader("encrypt")).getVersion().equals(this.getSymVersion())) {
            this.log.warn((Object)"attempting to use stored cipher as message does not uses current encryption version ");
            Cipher temp = (Cipher)this.keyMap.get(hdr.getVersion());
            if (temp == null) {
                this.log.warn((Object)"Unable to find a matching cipher in previous key map");
                return null;
            }
            this.log.info((Object)("Decrypting using previous cipher version " + hdr.getVersion()));
            msg.setBuffer(temp.doFinal(msg.getBuffer()));
            return msg;
        }
        msg.setBuffer(cipher.doFinal(msg.getBuffer()));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(" Decyphered message:" + this.formatArray(msg.getBuffer())));
        }
        return msg;
    }

    private void sendSecretKey(SecretKey secret, PublicKey pubKey, Address source) throws InvalidKeyException, IllegalStateException, IllegalBlockSizeException, BadPaddingException, NoSuchPaddingException, NoSuchAlgorithmException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"encoding shared key ");
        }
        Cipher tmp = Cipher.getInstance(this.asymAlgorithm);
        tmp.init(1, pubKey);
        byte[] encryptedKey = tmp.doFinal(secret.getEncoded());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(" Generated encoded key which only client can decode:" + this.formatArray(encryptedKey)));
        }
        Message newMsg = new Message(source, this.local_addr, encryptedKey);
        newMsg.putHeader("encrypt", new EncryptHeader(3, this.getSymVersion()));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(" Sending version " + this.getSymVersion() + " encoded key to client"));
        }
        this.passDown(new Event(1, newMsg));
    }

    private PublicKey handleKeyRequest(Message msg) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Request for key recieved");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Got peer's encoded public key:" + this.formatArray(msg.getBuffer())));
        }
        PublicKey pubKey = this.generatePubKey(msg.getBuffer());
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Generated requestors public key" + pubKey));
        }
        Message newMsg = new Message(msg.getSrc(), this.local_addr, this.Kpair.getPublic().getEncoded());
        if (this.log.isInfoEnabled()) {
            this.log.debug((Object)("encoded key is " + this.formatArray(this.Kpair.getPublic().getEncoded())));
        }
        newMsg.putHeader("encrypt", new EncryptHeader(2, this.getSymVersion()));
        this.passDown(new Event(1, newMsg));
        return pubKey;
    }

    private Message sendKeyRequest() {
        Message newMsg = new Message(this.keyServerAddr, this.local_addr, this.Kpair.getPublic().getEncoded());
        newMsg.putHeader("encrypt", new EncryptHeader(1, this.getSymVersion()));
        this.passDown(new Event(1, newMsg));
        return newMsg;
    }

    public void down(Event evt) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("down:evt is " + evt));
        }
        switch (evt.getType()) {
            case 1: {
                if (evt.getArg() == null || ((Message)evt.getArg()).getBuffer() == null) {
                    this.log.debug((Object)"passing down message as is empty message or buffer ");
                    break;
                }
                try {
                    if (this.queue_down) {
                        this.down_queue.add(evt);
                    } else {
                        this.handleDownEvent(evt);
                    }
                }
                catch (Exception e) {
                    this.log.warn((Object)("Unable to send down event " + e.getMessage()));
                }
                return;
            }
        }
        this.passDown(evt);
    }

    private void handleDownEvent(Event evt) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Handling down message");
        }
        if (!this.suppliedKey) {
            this.drainDownQueue();
        }
        this.sendDown(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drainDownQueue() throws Exception, QueueClosedException {
        Object object = this.downLock;
        synchronized (object) {
            while (this.down_queue.size() != 0) {
                this.sendDown((Event)this.down_queue.remove());
            }
        }
    }

    private void sendDown(Event evt) throws Exception {
        if (evt.getType() != 1) {
            return;
        }
        Message msg = (Message)evt.getArg();
        msg.putHeader("encrypt", new EncryptHeader(0, this.getSymVersion()));
        if (msg.getBuffer() != null) {
            this.encryptMessage(this.symEncodingCipher, msg);
        } else if (this.log.isInfoEnabled()) {
            this.log.info((Object)"buffer is null not encrypting ");
        }
        this.passDown(evt);
    }

    private Message encryptMessage(Cipher cipher, Message msg) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(" Starting to encypher message:" + this.formatArray(msg.getBuffer())));
        }
        msg.setBuffer(cipher.doFinal(msg.getBuffer()));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(" Encypher message:" + this.formatArray(msg.getBuffer())));
        }
        return msg;
    }

    private SecretKeySpec decodeKey(byte[] encodedKey) throws Exception {
        byte[] keyBytes = this.asymCipher.doFinal(encodedKey);
        SecretKeySpec keySpec = null;
        try {
            keySpec = new SecretKeySpec(keyBytes, this.getAlgorithm(this.symAlgorithm));
            Cipher temp = Cipher.getInstance(this.symAlgorithm);
            temp.init(3, keySpec);
        }
        catch (Exception e) {
            this.log.fatal((Object)e);
            keySpec = null;
        }
        return keySpec;
    }

    private PublicKey generatePubKey(byte[] encodedKey) {
        PublicKey pubKey = null;
        try {
            KeyFactory KeyFac = KeyFactory.getInstance(this.getAlgorithm(this.asymAlgorithm));
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(encodedKey);
            pubKey = KeyFac.generatePublic(x509KeySpec);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pubKey;
    }

    private String formatArray(byte[] array) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            buf.append(Integer.toHexString(array[i]));
        }
        return buf.toString();
    }

    protected int getAsymInit() {
        return this.asymInit;
    }

    protected String getAsymProvider() {
        return this.asymProvider;
    }

    protected SecretKey getDesKey() {
        return this.secretKey;
    }

    protected KeyPair getKpair() {
        return this.Kpair;
    }

    protected Cipher getAsymCipher() {
        return this.asymCipher;
    }

    protected PublicKey getServerPubKey() {
        return this.serverPubKey;
    }

    protected String getSymAlgorithm() {
        return this.symAlgorithm;
    }

    protected int getSymInit() {
        return this.symInit;
    }

    protected String getSymProvider() {
        return this.symProvider;
    }

    protected String getAsymAlgorithm() {
        return this.asymAlgorithm;
    }

    private String getSymVersion() {
        return this.symVersion;
    }

    private void setSymVersion(String symVersion) {
        this.symVersion = symVersion;
    }

    private SecretKey getSecretKey() {
        return this.secretKey;
    }

    private void setSecretKey(SecretKey secretKey) {
        this.secretKey = secretKey;
    }

    private void setServerPubKey(PublicKey serverPubKey) {
        this.serverPubKey = serverPubKey;
    }

    protected String getKeyStoreName() {
        return this.keyStoreName;
    }

    protected Cipher getSymDecodingCipher() {
        return this.symDecodingCipher;
    }

    protected Cipher getSymEncodingCipher() {
        return this.symEncodingCipher;
    }

    protected Address getLocal_addr() {
        return this.local_addr;
    }

    protected void setLocal_addr(Address local_addr) {
        this.local_addr = local_addr;
    }

    protected Address getKeyServerAddr() {
        return this.keyServerAddr;
    }

    protected void setKeyServerAddr(Address keyServerAddr) {
        this.keyServerAddr = keyServerAddr;
    }

    public static class EncryptHeader
    extends Header {
        int type;
        public static final int ENCRYPT = 0;
        public static final int KEY_REQUEST = 1;
        public static final int SERVER_PUBKEY = 2;
        public static final int SECRETKEY = 3;
        public static final int SECRETKEY_READY = 4;
        static final String KEY = "encrypt";
        String version;

        public EncryptHeader() {
        }

        public EncryptHeader(int type) {
            this.type = type;
            this.version = "";
        }

        public EncryptHeader(int type, String version) {
            this.type = type;
            this.version = version;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
            out.writeObject(this.version);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
            this.version = (String)in.readObject();
        }

        public String toString() {
            return "{ENCTYPT:[Type:" + this.type + " Version:" + this.version + "]}";
        }

        public boolean equals(Object obj) {
            if (obj instanceof EncryptHeader) {
                boolean res = ((EncryptHeader)obj).getType() == this.type && ((EncryptHeader)obj).getVersion() == this.version;
                return res;
            }
            return false;
        }

        protected int getType() {
            return this.type;
        }

        protected String getVersion() {
            return this.version;
        }
    }
}

