/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class FD
extends Protocol
implements Runnable {
    Address local_addr = null;
    Thread checker = null;
    long timeout = 6000L;
    Hashtable members = new Hashtable(11);
    Vector suspected_mbrs = new Vector(11);

    public String getName() {
        return "FD";
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("timeout");
        if (str != null) {
            this.timeout = Long.parseLong(str);
            props.remove("timeout");
        }
        if (props.size() > 0) {
            System.err.println("FD.setProperties(): the following properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void stop() {
        this.stopChecker();
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                Address sender = msg.getSrc();
                this.updateSender(sender);
            }
        }
        this.passUp(evt);
    }

    public void down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                View v = (View)evt.getArg();
                Vector mbrs = v.getMembers();
                this.passDown(evt);
                Enumeration e = this.members.keys();
                while (e.hasMoreElements()) {
                    Address mbr = (Address)e.nextElement();
                    if (mbrs.contains(mbr)) continue;
                    this.members.remove(mbr);
                }
                this.members.remove(this.local_addr);
                if (this.members.size() > 0 && this.checker == null) {
                    this.startChecker();
                }
                return;
            }
            case 50: {
                this.updateSenders((Vector)evt.getArg());
                return;
            }
        }
        this.passDown(evt);
    }

    public void run() {
        while (this.checker != null && this.members.size() > 0) {
            Enumeration e = this.members.keys();
            while (e.hasMoreElements()) {
                Address mbr = (Address)e.nextElement();
                long timestamp = ((Entry)this.members.get((Object)mbr)).timestamp;
                long diff = System.currentTimeMillis() - timestamp;
                if (diff < this.timeout) continue;
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("suspecting " + mbr));
                }
                this.passUp(new Event(9, mbr));
                if (this.suspected_mbrs.contains(mbr)) continue;
                this.suspected_mbrs.addElement(mbr);
            }
            Util.sleep(this.timeout);
        }
        this.checker = null;
    }

    synchronized void startChecker() {
        if (this.checker == null) {
            this.checker = new Thread((Runnable)this, "FD.CheckerThread");
            this.checker.setDaemon(true);
            this.checker.start();
        }
    }

    synchronized void stopChecker() {
        Thread tmp = null;
        if (this.checker != null && this.checker.isAlive()) {
            tmp = this.checker;
            this.checker = null;
            tmp.interrupt();
            try {
                tmp.join(this.timeout);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tmp.isAlive() && this.log.isWarnEnabled()) {
                this.log.warn((Object)"interrupted checker thread is still alive !");
            }
        }
        this.checker = null;
    }

    void updateSender(Address mbr) {
        long curr_time = 0L;
        if (mbr == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("member " + mbr + " not found"));
            }
            return;
        }
        if (this.suspected_mbrs.size() > 0 && this.suspected_mbrs.contains(mbr)) {
            this.passUp(new Event(51, mbr));
            this.suspected_mbrs.remove(mbr);
        }
        if (mbr.equals(this.local_addr)) {
            return;
        }
        Entry entry = (Entry)this.members.get(mbr);
        curr_time = System.currentTimeMillis();
        if (entry != null) {
            entry.timestamp = curr_time;
        } else {
            this.members.put(mbr, new Entry(curr_time));
        }
    }

    void updateSenders(Vector v) {
        if (v == null) {
            return;
        }
        for (int i = 0; i < v.size(); ++i) {
            Address mbr = (Address)v.elementAt(i);
            this.updateSender(mbr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String printTimestamps() {
        StringBuffer sb = new StringBuffer();
        Hashtable hashtable = this.members;
        synchronized (hashtable) {
            Enumeration e = this.members.keys();
            while (e.hasMoreElements()) {
                Address mbr = (Address)e.nextElement();
                sb.append("\n" + mbr + ": " + (System.currentTimeMillis() - ((Entry)this.members.get((Object)mbr)).timestamp));
            }
        }
        return sb.toString();
    }

    static class Entry {
        long timestamp;

        Entry(long timestamp) {
            this.timestamp = timestamp;
        }

        public String toString() {
            return Long.toString(this.timestamp);
        }
    }
}

