/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jgroups.Message;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.List;

public class MessageSerializationTest2 {
    public void start(int num) throws IOException {
        int NUM = num;
        List my_list = new List();
        IpAddress dest = new IpAddress(7500);
        System.out.println("-- starting to create " + NUM + " msgs");
        long start = System.currentTimeMillis();
        for (int i = 1; i <= NUM; ++i) {
            Message msg = new Message(null, null, (Serializable)((Object)("Hello world from message #" + i)));
            my_list.add(msg);
        }
        long stop = System.currentTimeMillis();
        long total = stop - start;
        double msgs_per_sec = (double)NUM / ((double)total / 1000.0);
        double time_per_msg = (double)total / (double)NUM;
        System.out.println("\n-- total time for creating " + NUM + " msgs = " + total + "ms \n(" + msgs_per_sec + " msgs/sec, time_per_msg=" + time_per_msg + " ms)");
        System.out.println("-- starting to serialize " + NUM + " msgs");
        start = System.currentTimeMillis();
        ByteArrayOutputStream output = new ByteArrayOutputStream(1024);
        ObjectOutputStream out = new ObjectOutputStream(output);
        my_list.writeExternal(out);
        out.close();
        byte[] buf = output.toByteArray();
        stop = System.currentTimeMillis();
        total = stop - start;
        msgs_per_sec = (double)NUM / ((double)total / 1000.0);
        time_per_msg = (double)total / (double)NUM;
        System.out.println("\n-- total time for serializing " + NUM + " msgs = " + total + "ms \n(" + msgs_per_sec + " msgs/sec, time_per_msg=" + time_per_msg + " ms)");
        System.out.println("-- starting to unserialize msgs");
        start = System.currentTimeMillis();
        ByteArrayInputStream input = new ByteArrayInputStream(buf);
        ObjectInputStream in = new ObjectInputStream(input);
        int msgs_read = 0;
        List l2 = new List();
        try {
            l2.readExternal(in);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        stop = System.currentTimeMillis();
        total = stop - start;
        msgs_read = l2.size();
        msgs_per_sec = (double)msgs_read / ((double)total / 1000.0);
        time_per_msg = (double)total / (double)msgs_read;
        System.out.println("\n-- total time for reading " + msgs_read + " msgs = " + total + "ms \n(" + msgs_per_sec + " msgs/sec, time_per_msg=" + time_per_msg + ')');
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("MessageTest <num>");
            return;
        }
        try {
            new MessageSerializationTest2().start(Integer.parseInt(args[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

