/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.Serializable;
import java.util.logging.Logger;

class TestMessage
implements Serializable {
    static final String COMPONENT = "TestMessage";
    static final Logger logger = Logger.getLogger("TestMessage");
    public static final int MSG_SIZE = 40960;
    private long seqNumber = -1L;
    private long created;
    private byte[] content;
    private Serializable obj;

    public TestMessage() {
        this.created = System.currentTimeMillis();
    }

    public TestMessage(byte[] content) {
        this();
        this.content = content;
    }

    public TestMessage(long seqNumber, byte[] content) {
        this();
        this.seqNumber = seqNumber;
        this.content = content;
    }

    public TestMessage(Serializable obj) {
        this(-1L, obj);
    }

    public TestMessage(long seqNumber, Serializable obj) {
        this.seqNumber = seqNumber;
        this.obj = obj;
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public Serializable getObj() {
        return this.obj;
    }

    public void setObj(Serializable obj) {
        this.obj = obj;
    }

    public long getSeqNumber() {
        return this.seqNumber;
    }

    public void setSeqNumber(long newSeqNumber) {
        this.seqNumber = newSeqNumber;
    }

    public String toString() {
        String s = null;
        s = "TestMessage[" + this.seqNumber + "], latency=[" + this.calculateLatency() + "ms]";
        return s;
    }

    public String toStringFull() {
        String s = null;
        if (this.content != null) {
            s = "TestMessage[" + this.seqNumber + "] is: " + new String(this.content);
        } else if (this.obj != null) {
            s = "TestMessage[" + this.seqNumber + "] is: " + this.obj.toString();
        } else {
            throw new IllegalStateException("TestMessage content and object are null");
        }
        return s;
    }

    long calculateLatency() {
        long latency = 0L;
        latency = System.currentTimeMillis() - this.created;
        return latency;
    }
}

