/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.adaptjms;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.InitialContext;
import org.apache.log4j.Logger;
import org.jgroups.tests.adaptjms.JmsTester;

public class Test {
    public static int mcast_port = 7777;
    public static String mcast_addr = "228.8.8.8";
    public static int grpMembers = 4;
    static /* synthetic */ Class class$org$jgroups$tests$adaptjms$Test;

    public static void main(String[] args) {
        String config = "config.txt";
        boolean sender = false;
        int num_msgs = 1000;
        int msg_size = 500;
        int num_senders = 1;
        long log_interval = 1000L;
        String topic_name = "topic/testTopic";
        for (int i = 0; i < args.length; ++i) {
            if ("-sender".equals(args[i])) {
                sender = true;
                continue;
            }
            if ("-receiver".equals(args[i])) {
                sender = false;
                continue;
            }
            if ("-config".equals(args[i])) {
                config = args[++i];
                continue;
            }
            Test.help();
            return;
        }
        try {
            String line;
            BufferedReader fileReader = new BufferedReader(new FileReader(config));
            while ((line = fileReader.readLine()) != null) {
                String gnuplot_output;
                if (line.startsWith("#")) continue;
                if (line.startsWith("NUM_MSGS=")) {
                    num_msgs = Integer.parseInt(line.substring(line.indexOf(61) + 1, line.indexOf(59)));
                    continue;
                }
                if (line.startsWith("MSG_SIZE=")) {
                    msg_size = Integer.parseInt(line.substring(line.indexOf(61) + 1, line.indexOf(59)));
                    continue;
                }
                if (line.startsWith("GRPMEMBERS=")) {
                    grpMembers = Integer.parseInt(line.substring(line.indexOf(61) + 1, line.indexOf(59)));
                    continue;
                }
                if (line.startsWith("NUM_SENDERS=")) {
                    num_senders = Integer.parseInt(line.substring(line.indexOf(61) + 1, line.indexOf(59)));
                    continue;
                }
                if (line.startsWith("LOG_INTERVAL=")) {
                    log_interval = Long.parseLong(line.substring(line.indexOf(61) + 1, line.indexOf(59)));
                    continue;
                }
                if (line.startsWith("TOPIC=")) {
                    topic_name = line.substring(line.indexOf(61) + 1, line.indexOf(59));
                    continue;
                }
                if (!line.startsWith("GNUPLOT_OUTPUT=") || System.getProperty("gnuplot_output") != null || (gnuplot_output = line.substring(line.indexOf(61) + 1, line.indexOf(59)).trim()) == null) continue;
                System.setProperty("gnuplot_output", gnuplot_output);
            }
            fileReader.close();
            System.out.println("Javagroups test:");
            String s = "Initial params parsing completed. Starting test with these values:\nSender:" + sender + "  num_msgs:" + num_msgs + "  Size(bytes):" + msg_size + "  # Mbrs:" + grpMembers + "  Senders: " + num_senders + "\nLog interval: " + log_interval + '\n';
            System.out.println(s);
            Logger.getLogger((Class)(class$org$jgroups$tests$adaptjms$Test == null ? (class$org$jgroups$tests$adaptjms$Test = Test.class$("org.jgroups.tests.adaptjms.Test")) : class$org$jgroups$tests$adaptjms$Test)).info((Object)("main(): " + s));
            InitialContext ctx = new InitialContext();
            ConnectionFactory factory = (ConnectionFactory)ctx.lookup("ConnectionFactory");
            TopicConnection conn = ((TopicConnectionFactory)factory).createTopicConnection();
            TopicSession session = conn.createTopicSession(false, 1);
            Topic topic = (Topic)ctx.lookup(topic_name);
            TopicPublisher pub = session.createPublisher(topic);
            new JmsTester((Connection)conn, session, topic, pub, sender, num_msgs, msg_size, grpMembers, num_senders, log_interval).initialize();
        }
        catch (FileNotFoundException notFound) {
            System.err.println("File not found.\n" + notFound);
        }
        catch (IOException ioError) {
            System.err.println(ioError);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static List parseCommaDelimitedList(String s) throws Exception {
        ArrayList<InetAddress> retval = new ArrayList<InetAddress>();
        if (s == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(s, ",");
        while (tok.hasMoreTokens()) {
            InetAddress host = InetAddress.getByName(tok.nextToken());
            retval.add(host);
        }
        return retval;
    }

    static void help() {
        System.out.println("Test [-help] ([-sender] | [-receiver]) [-config <config file>]");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

