/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.stack;

import java.io.EOFException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.net.Socket;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.stack.GossipData;
import org.jgroups.stack.IpAddress;
import org.jgroups.tests.stack.Utilities;

public class GossipTest
extends TestCase {
    private final boolean USE_ROUTER = true;
    private int port = -1;
    private long expiryTime = 10000L;
    static /* synthetic */ Class class$org$jgroups$tests$stack$GossipTest;

    public GossipTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.port = Utilities.startGossipRouter(this.expiryTime);
    }

    public void tearDown() throws Exception {
        super.tearDown();
        Utilities.stopGossipRouter();
    }

    public void testEmptyGET() throws Exception {
        String groupName = "nosuchgroup";
        Socket s = new Socket("localhost", this.port);
        ObjectOutputStream oos = new ObjectOutputStream(s.getOutputStream());
        GossipData greq = new GossipData(2, groupName, null, null);
        oos.writeObject(greq);
        oos.flush();
        ObjectInputStream ois = new ObjectInputStream(s.getInputStream());
        GossipData gres = (GossipData)ois.readObject();
        GossipTest.assertEquals((int)3, (int)gres.getType());
        GossipTest.assertEquals((String)groupName, (String)gres.getGroup());
        Vector mbrs = gres.getMbrs();
        GossipTest.assertNull((Object)mbrs);
        oos.close();
        ois.close();
        s.close();
    }

    public void testLazyClient() throws Exception {
        String groupName = "TESTGROUP";
        Socket s = new Socket("localhost", this.port);
        ObjectOutputStream oos = new ObjectOutputStream(s.getOutputStream());
        GossipData greq = new GossipData(2, groupName, null, null);
        Thread.sleep(1500L);
        oos.writeObject(greq);
        oos.flush();
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(s.getInputStream());
            GossipTest.fail((String)"Stream creation should have failed");
        }
        catch (Exception e) {
            GossipTest.assertTrue((boolean)(e instanceof StreamCorruptedException));
        }
        oos.close();
        s.close();
        s = new Socket("localhost", this.port);
        oos = new ObjectOutputStream(s.getOutputStream());
        greq = new GossipData(2, groupName, null, null);
        oos.writeObject(greq);
        oos.flush();
        ois = new ObjectInputStream(s.getInputStream());
        GossipData gres = (GossipData)ois.readObject();
        GossipTest.assertEquals((int)3, (int)gres.getType());
        GossipTest.assertEquals((String)groupName, (String)gres.getGroup());
        Vector mbrs = gres.getMbrs();
        GossipTest.assertNull((Object)mbrs);
        oos.close();
        ois.close();
        s.close();
    }

    public void test_REGISTER_GET() throws Exception {
        GossipData greq;
        ObjectOutputStream oos;
        Socket s;
        int mbrPort;
        String groupName;
        block2: {
            groupName = "TESTGROUP";
            mbrPort = 7777;
            s = new Socket("localhost", this.port);
            oos = new ObjectOutputStream(s.getOutputStream());
            IpAddress mbr = new IpAddress("localhost", mbrPort);
            greq = new GossipData(1, groupName, mbr, null);
            oos.writeObject(greq);
            oos.flush();
            try {
                s.getInputStream();
            }
            catch (EOFException e) {
                if (e instanceof EOFException) break block2;
                GossipTest.fail((String)"The input stream was supposed to throw EOFException");
            }
        }
        oos.close();
        s.close();
        s = new Socket("localhost", this.port);
        oos = new ObjectOutputStream(s.getOutputStream());
        greq = new GossipData(2, groupName, null, null);
        oos.writeObject(greq);
        oos.flush();
        ObjectInputStream ois = new ObjectInputStream(s.getInputStream());
        GossipData gres = (GossipData)ois.readObject();
        GossipTest.assertEquals((int)3, (int)gres.getType());
        GossipTest.assertEquals((String)groupName, (String)gres.getGroup());
        Vector mbrs = gres.getMbrs();
        GossipTest.assertEquals((int)1, (int)mbrs.size());
        GossipTest.assertEquals((Object)new IpAddress("localhost", mbrPort), mbrs.get(0));
        oos.close();
        ois.close();
        s.close();
    }

    public void testSweep() throws Exception {
        String groupName = "TESTGROUP";
        int mbrPort = 7777;
        Socket s = new Socket("localhost", this.port);
        ObjectOutputStream oos = new ObjectOutputStream(s.getOutputStream());
        IpAddress mbr = new IpAddress("localhost", mbrPort);
        GossipData greq = new GossipData(1, groupName, mbr, null);
        oos.writeObject(greq);
        oos.flush();
        oos.close();
        s.close();
        s = new Socket("localhost", this.port);
        oos = new ObjectOutputStream(s.getOutputStream());
        greq = new GossipData(2, groupName, null, null);
        oos.writeObject(greq);
        oos.flush();
        ObjectInputStream ois = new ObjectInputStream(s.getInputStream());
        GossipData gres = (GossipData)ois.readObject();
        GossipTest.assertEquals((int)3, (int)gres.getType());
        GossipTest.assertEquals((String)groupName, (String)gres.getGroup());
        Vector mbrs = gres.getMbrs();
        GossipTest.assertEquals((int)1, (int)mbrs.size());
        GossipTest.assertEquals((Object)new IpAddress("localhost", mbrPort), mbrs.get(0));
        oos.close();
        ois.close();
        s.close();
        Thread.sleep(2L * this.expiryTime);
        s = new Socket("localhost", this.port);
        oos = new ObjectOutputStream(s.getOutputStream());
        greq = new GossipData(2, groupName, null, null);
        oos.writeObject(greq);
        oos.flush();
        ois = new ObjectInputStream(s.getInputStream());
        gres = (GossipData)ois.readObject();
        GossipTest.assertEquals((int)3, (int)gres.getType());
        GossipTest.assertEquals((String)groupName, (String)gres.getGroup());
        mbrs = gres.getMbrs();
        GossipTest.assertEquals((int)0, (int)mbrs.size());
        oos.close();
        ois.close();
        s.close();
    }

    public static Test suite() {
        TestSuite s = new TestSuite(class$org$jgroups$tests$stack$GossipTest == null ? (class$org$jgroups$tests$stack$GossipTest = GossipTest.class$("org.jgroups.tests.stack.GossipTest")) : class$org$jgroups$tests$stack$GossipTest);
        return s;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)GossipTest.suite());
        System.exit(0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

