/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.setup;

import com.sun.tdk.signaturetest.ClassDescrLoader;
import com.sun.tdk.signaturetest.ClassDescription;
import com.sun.tdk.signaturetest.FullItemDescription;
import com.sun.tdk.signaturetest.SortedVector;
import java.util.Enumeration;
import java.util.Vector;

public class ClassNameSorter {
    private SVector nestedClasses = new SVector();
    private SVector regularClasses = new SVector();
    private SVector classes = new SVector();
    private ClassDescrLoader loader;
    public Vector errors = new Vector();

    public ClassNameSorter(Vector vector, ClassDescrLoader classDescrLoader) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.classes.insert(enumeration.nextElement());
        }
        this.loader = classDescrLoader;
    }

    void foundNested(FullItemDescription fullItemDescription) {
        if (fullItemDescription == null) {
            return;
        }
        String string = fullItemDescription.getName();
        if (string.indexOf(36) < 0) {
            if (this.regularClasses.contains(string)) {
                return;
            }
            this.regularClasses.insert(string);
        } else {
            if (this.nestedClasses.contains(string)) {
                return;
            }
            this.nestedClasses.insert(string);
        }
        ClassDescription classDescription = this.load(fullItemDescription);
        if (classDescription == null) {
            return;
        }
        this.foundNested(classDescription.getSuperclass());
        FullItemDescription[] fullItemDescriptionArray = classDescription.getInterfaces();
        int n = 0;
        while (n < fullItemDescriptionArray.length) {
            this.foundNested(fullItemDescriptionArray[n]);
            ++n;
        }
        FullItemDescription[] fullItemDescriptionArray2 = classDescription.getDeclaredClasses();
        int n2 = 0;
        while (n2 < fullItemDescriptionArray2.length) {
            this.foundNested(fullItemDescriptionArray2[n2]);
            ++n2;
        }
    }

    public Vector getSortedClasses(Vector vector) {
        Object object;
        this.errors = vector;
        int n = 0;
        while (n < this.classes.size()) {
            object = this.load((String)this.classes.elementAt(n));
            if (object != null) {
                this.foundNested((FullItemDescription)object);
            }
            ++n;
        }
        object = new Vector();
        int n2 = 0;
        while (n2 < this.nestedClasses.size()) {
            ((Vector)object).addElement(this.nestedClasses.elementAt(n2));
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.classes.size()) {
            String string = (String)this.classes.elementAt(n3);
            if (string.indexOf(36) < 0) {
                ((Vector)object).addElement(string);
            }
            ++n3;
        }
        return object;
    }

    public boolean isAccessible(String string) {
        if (string == null) {
            return false;
        }
        if (string.indexOf(36) >= 0) {
            return this.nestedClasses.contains(string);
        }
        return this.regularClasses.contains(string);
    }

    private ClassDescription load(FullItemDescription fullItemDescription) {
        if (fullItemDescription instanceof ClassDescription) {
            return (ClassDescription)fullItemDescription;
        }
        return this.load(fullItemDescription.getName());
    }

    private ClassDescription load(String string) {
        block4: {
            try {
                return this.loader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!this.errors.contains("Class not found: " + string)) {
                    this.errors.addElement("Class not found: " + string);
                }
            }
            catch (LinkageError linkageError) {
                if (this.errors.contains("Class not linked: " + string)) break block4;
                this.errors.addElement("Class not linked: " + string);
            }
        }
        return null;
    }

    private class SVector
    extends SortedVector {
        private SVector() {
        }

        protected int compare(Object object, Object object2) {
            if (object instanceof String && object2 instanceof String) {
                return ((String)object).compareTo((String)object2);
            }
            return object.hashCode() - object2.hashCode();
        }

        public boolean contains(Object object) {
            if (this.size() == 0) {
                return false;
            }
            int n = 0;
            int n2 = this.size() - 1;
            int n3 = (n + n2) / 2;
            while (n <= n2) {
                n3 = (n + n2) / 2;
                Object object2 = this.elementAt(n3);
                int n4 = this.compare(object, object2);
                if (n4 == 0) {
                    return true;
                }
                if (n4 < 0) {
                    n2 = n3 - 1;
                    continue;
                }
                n = n3 + 1;
            }
            return false;
        }
    }
}

