/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl;

import de.odysseus.el.misc.LocalMessages;
import de.odysseus.el.tree.NodePrinter;
import de.odysseus.el.tree.Tree;
import de.odysseus.el.tree.TreeBuilder;
import de.odysseus.el.tree.impl.Parser;
import de.odysseus.el.tree.impl.Scanner;
import de.odysseus.el.util.SimpleContext;
import java.io.PrintWriter;
import java.util.EnumSet;
import javax.el.ELException;

public class Builder
implements TreeBuilder {
    private static final long serialVersionUID = 1L;
    private final EnumSet<Feature> features;

    public Builder() {
        this.features = EnumSet.noneOf(Feature.class);
    }

    public Builder(Feature ... featureArray) {
        if (featureArray == null || featureArray.length == 0) {
            this.features = EnumSet.noneOf(Feature.class);
        } else if (featureArray.length == 1) {
            this.features = EnumSet.of(featureArray[0]);
        } else {
            Feature[] featureArray2 = new Feature[featureArray.length - 1];
            for (int i = 1; i < featureArray.length; ++i) {
                featureArray2[i - 1] = featureArray[i];
            }
            this.features = EnumSet.of(featureArray[0], featureArray2);
        }
    }

    protected Number parseInteger(String string) throws NumberFormatException {
        return Long.valueOf(string);
    }

    protected Number parseFloat(String string) throws NumberFormatException {
        return Double.valueOf(string);
    }

    public boolean isEnabled(Feature feature) {
        return this.features.contains((Object)feature);
    }

    public Tree build(String string) throws ELException {
        try {
            return new Parser(this, string).tree();
        }
        catch (Scanner.ScanException scanException) {
            throw new ELException(LocalMessages.get("error.build", string, scanException.getMessage()));
        }
        catch (Parser.ParseException parseException) {
            throw new ELException(LocalMessages.get("error.build", string, parseException.getMessage()));
        }
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.features.equals(((Builder)object).features);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("usage: java " + Builder.class.getName() + " <expression string>");
            System.exit(1);
        }
        PrintWriter printWriter = new PrintWriter(System.out);
        Tree tree = null;
        try {
            tree = new Builder(Feature.METHOD_INVOCATIONS).build(stringArray[0]);
        }
        catch (ELException eLException) {
            System.out.println(eLException.getMessage());
            System.exit(0);
        }
        NodePrinter.dump(printWriter, tree.getRoot());
        if (!tree.getFunctionNodes().iterator().hasNext() && !tree.getIdentifierNodes().iterator().hasNext()) {
            printWriter.print(">> ");
            try {
                printWriter.println(tree.getRoot().getValue(null, new SimpleContext(), null));
            }
            catch (ELException eLException) {
                printWriter.println(eLException.getMessage());
            }
        }
        printWriter.flush();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Feature {
        METHOD_INVOCATIONS,
        NULL_PROPERTIES;

    }
}

