/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.charting.plotters;

import java.awt.Graphics2D;
import kg.apc.charting.AbstractGraphRow;
import kg.apc.charting.ChartSettings;
import kg.apc.charting.CubicSpline;
import kg.apc.charting.plotters.AbstractRowPlotter;
import org.apache.jorphan.gui.NumberRenderer;

public class CSplineRowPlotter
extends AbstractRowPlotter {
    private long splineLinesCount = 200L;

    public CSplineRowPlotter(ChartSettings chartSettings, NumberRenderer labelRenderer) {
        super(chartSettings, labelRenderer);
        this.allowMarkers = true;
    }

    @Override
    protected void processPoint(Graphics2D g2d, int granulation) {
    }

    @Override
    protected void postPaintRow(AbstractGraphRow row, Graphics2D g2d) {
        if (this.chartSettings.getLineWidth() == 0.0f) {
            return;
        }
        if (row.size() >= 3) {
            CubicSpline cs = new CubicSpline(row);
            long minX = row.getMinX();
            long maxX = row.getMaxX();
            double step = (double)(maxX - minX) / (double)this.splineLinesCount;
            double currentX = minX;
            while (currentX <= (double)maxX) {
                this.x = this.chartRect.x + (int)((currentX - (double)this.minXVal) * this.dxForDVal);
                int yHeight = (int)((cs.interpolate(currentX) - this.minYVal) * this.dyForDVal);
                this.y = this.chartRect.y + this.chartRect.height - yHeight;
                if (this.y < this.chartRect.y) {
                    this.y = this.chartRect.y;
                }
                if (this.y > this.chartRect.y + this.chartRect.height) {
                    this.y = this.chartRect.y + this.chartRect.height;
                }
                currentX += step;
                if (this.prevX >= 0) {
                    g2d.drawLine(this.prevX, this.prevY, this.x, this.y);
                }
                this.prevX = this.x;
                this.prevY = this.y;
            }
        }
    }
}

