/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import org.apache.jmeter.gui.GuiPackage;

public class BrowseAction
implements ActionListener {
    private final JTextField control;
    private boolean isDirectoryBrowse = false;
    private String lastPath = ".";

    public BrowseAction(JTextField filename) {
        this.control = filename;
    }

    public BrowseAction(JTextField filename, boolean isDirectoryBrowse) {
        this.control = filename;
        this.isDirectoryBrowse = isDirectoryBrowse;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = this.getFileChooser();
        if (chooser != null && GuiPackage.getInstance() != null) {
            int returnVal = chooser.showOpenDialog((Component)GuiPackage.getInstance().getMainFrame());
            if (returnVal == 0) {
                this.control.setText(chooser.getSelectedFile().getPath());
            }
            this.lastPath = chooser.getCurrentDirectory().getPath();
        }
    }

    protected JFileChooser getFileChooser() {
        JFileChooser ret = new JFileChooser(this.lastPath);
        if (this.isDirectoryBrowse) {
            ret.setFileSelectionMode(1);
        }
        return ret;
    }
}

