/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.io;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Set;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class SocketChannelWithTimeouts
extends SocketChannel {
    protected SocketChannel socketChannel;
    protected Selector selector;
    private long connectTimeout = 5000L;
    private long readTimeout = 10000L;
    protected SelectionKey channelKey;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private boolean fastFirstPacketRead;

    protected SocketChannelWithTimeouts() throws IOException {
        super(null);
        log.debug("Creating socketChannel");
        this.selector = Selector.open();
        this.socketChannel = SocketChannel.open();
        this.socketChannel.configureBlocking(false);
        this.channelKey = this.socketChannel.register(this.selector, 8);
    }

    public static SocketChannel open() throws IOException {
        return new SocketChannelWithTimeouts();
    }

    @Override
    public SocketChannel bind(SocketAddress socketAddress) throws IOException {
        return this.socketChannel.bind(socketAddress);
    }

    @Override
    public SocketAddress getLocalAddress() throws IOException {
        return this.socketChannel.getLocalAddress();
    }

    @Override
    public <T> SocketChannel setOption(SocketOption<T> socketOption, T t) throws IOException {
        return this.socketChannel.setOption((SocketOption)socketOption, (Object)t);
    }

    @Override
    public <T> T getOption(SocketOption<T> socketOption) throws IOException {
        return this.socketChannel.getOption(socketOption);
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        return this.socketChannel.supportedOptions();
    }

    @Override
    public SocketChannel shutdownInput() throws IOException {
        return this.socketChannel.shutdownInput();
    }

    @Override
    public SocketChannel shutdownOutput() throws IOException {
        return this.socketChannel.shutdownOutput();
    }

    @Override
    public boolean connect(SocketAddress remote) throws IOException {
        long start = System.currentTimeMillis();
        this.socketChannel.connect(remote);
        if (this.selector.select(this.connectTimeout) > 0) {
            this.selector.selectedKeys().remove(this.channelKey);
            if (!this.channelKey.isConnectable()) {
                throw new IllegalStateException("Socket channel is in not connectable state");
            }
            this.socketChannel.finishConnect();
            this.channelKey = this.socketChannel.register(this.selector, 1);
            if (log.isDebugEnabled()) {
                log.debug("Connected socket in " + (System.currentTimeMillis() - start));
            }
            if (!this.socketChannel.isConnected()) {
                throw new SocketException("SocketChannel not connected on some reason");
            }
            return true;
        }
        throw new SocketTimeoutException("Failed to connect to " + remote.toString());
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int bytesRead = 0;
        while (this.selector.select(this.readTimeout) > 0) {
            this.selector.selectedKeys().remove(this.channelKey);
            int cnt = this.socketChannel.read(dst);
            if (cnt < 1) {
                if (bytesRead < 1) {
                    bytesRead = -1;
                }
                return bytesRead;
            }
            bytesRead += cnt;
            if (this.fastFirstPacketRead) continue;
            this.fastFirstPacketRead = true;
            return bytesRead;
        }
        throw new SocketTimeoutException("Timeout exceeded while reading from socket");
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int res;
        this.fastFirstPacketRead = false;
        int size = src.remaining();
        for (res = 0; res < size; res += this.socketChannel.write(src)) {
        }
        return res;
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void implCloseSelectableChannel() throws IOException {
        this.socketChannel.close();
        this.selector.close();
    }

    @Override
    protected void implConfigureBlocking(boolean block) throws IOException {
        throw new UnsupportedOperationException("This class is blocking implementation of SocketChannel");
    }

    @Override
    public Socket socket() {
        return this.socketChannel.socket();
    }

    @Override
    public boolean isConnected() {
        return this.socketChannel.isConnected();
    }

    @Override
    public boolean isConnectionPending() {
        return this.socketChannel.isConnectionPending();
    }

    @Override
    public boolean finishConnect() throws IOException {
        return this.socketChannel.finishConnect();
    }

    public void setConnectTimeout(int t) {
        this.connectTimeout = t;
    }

    public void setReadTimeout(int t) {
        this.readTimeout = t;
    }

    @Override
    public SocketAddress getRemoteAddress() throws IOException {
        return null;
    }
}

