/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.vizualizers;

import kg.apc.charting.AbstractGraphRow;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.graphs.AbstractOverTimeVisualizer;
import kg.apc.jmeter.vizualizers.JSettingsPanel;
import org.apache.jmeter.protocol.http.sampler.HTTPSampleResult;
import org.apache.jmeter.samplers.SampleResult;

public class ResponseCodesPerSecondGui
extends AbstractOverTimeVisualizer {
    private String prefix = null;

    public ResponseCodesPerSecondGui() {
        this.setGranulation(1000);
        this.graphPanel.getGraphObject().setYAxisLabel("Number of reponses /sec");
    }

    private void addResponse(String threadGroupName, long time) {
        AbstractGraphRow row = (AbstractGraphRow)this.model.get(threadGroupName);
        if (row == null) {
            row = this.getNewRow(this.model, 4, threadGroupName, 2, false, false, false, true, true);
        }
        if (this.getGranulation() > 0) {
            row.add(time, 1000.0 / (double)this.getGranulation());
        }
    }

    public String getLabelResource() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel("Response Codes per Second");
    }

    @Override
    public void clearData() {
        super.clearData();
        this.prefix = null;
    }

    private String getRespCodeLabel(SampleResult res) {
        String ret = this.prefix;
        if (ret == null) {
            if (res instanceof HTTPSampleResult) {
                this.prefix = "HTTP_";
                ret = "HTTP_";
            } else {
                this.prefix = "";
                ret = "";
            }
        }
        return ret + res.getResponseCode();
    }

    private void addCodes(SampleResult res) {
        SampleResult[] subResults = res.getSubResults();
        if (!this.isFromTransactionControler(res)) {
            this.addResponse(this.getRespCodeLabel(res), this.normalizeTime(res.getEndTime()));
        }
        for (int i = 0; i < subResults.length; ++i) {
            this.addCodes(subResults[i]);
        }
    }

    @Override
    public void add(SampleResult res) {
        if (!this.isSampleIncluded(res)) {
            return;
        }
        super.add(res);
        this.addCodes(res);
        this.updateGui(null);
    }

    @Override
    protected JSettingsPanel createSettingsPanel() {
        return new JSettingsPanel(this, 2843);
    }

    @Override
    public String getWikiPage() {
        return "ResponseCodesPerSecond";
    }
}

