/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.webdriver.phantomjs;

import com.blazemeter.jmeter.webdriver.phantomjs.PhantomJSDriverConfig;
import com.googlecode.jmeter.plugins.webdriver.config.gui.WebDriverConfigGui;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.TestElement;

public class PhantomJSDriverConfigGui
extends WebDriverConfigGui {
    private static final long serialVersionUID = 100L;
    JTextField phantomJsExecutablePath;
    JTextField phantomJsCliArgs;
    JTextField phantomJsGhostdriverCliArgs;

    public String getStaticLabel() {
        return "bzm - PhantomJS Driver Config";
    }

    public String getLabelResource() {
        return this.getClass().getCanonicalName();
    }

    @Override
    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof PhantomJSDriverConfig) {
            PhantomJSDriverConfig config = (PhantomJSDriverConfig)element;
            this.phantomJsExecutablePath.setText(config.getPhantomJsExecutablePath());
            this.phantomJsCliArgs.setText(config.getPhantomJsCliArgs());
            this.phantomJsGhostdriverCliArgs.setText(config.getPhantomJsGhostdriverCliArgs());
        }
    }

    public TestElement createTestElement() {
        PhantomJSDriverConfig element = new PhantomJSDriverConfig();
        this.modifyTestElement((TestElement)element);
        return element;
    }

    @Override
    public void modifyTestElement(TestElement element) {
        super.modifyTestElement(element);
        if (element instanceof PhantomJSDriverConfig) {
            PhantomJSDriverConfig config = (PhantomJSDriverConfig)element;
            config.setPhantomJsExecutablePath(this.phantomJsExecutablePath.getText());
            config.setPhantomJsCliArgs(this.phantomJsCliArgs.getText());
            config.setPhantomJsGhostdriverCliArgs(this.phantomJsGhostdriverCliArgs.getText());
        }
    }

    @Override
    public void clearGui() {
        super.clearGui();
        this.phantomJsExecutablePath.setText("");
        this.phantomJsCliArgs.setText("");
        this.phantomJsGhostdriverCliArgs.setText("");
    }

    @Override
    protected JPanel createBrowserPanel() {
        return this.buildGui();
    }

    @Override
    protected String browserName() {
        return "PhantomJS";
    }

    @Override
    protected String getWikiPage() {
        return "PhantomJSDriverConfig";
    }

    @Override
    protected boolean isProxyEnabled() {
        return true;
    }

    @Override
    protected boolean isExperimentalEnabled() {
        return true;
    }

    private JPanel buildGui() {
        VerticalPanel browserPanel = new VerticalPanel();
        HorizontalPanel phantomJsExecutablePanel = new HorizontalPanel();
        JLabel phantomJsExecutableLabel = new JLabel("Path to PhantomJS executable");
        phantomJsExecutablePanel.add(phantomJsExecutableLabel);
        this.phantomJsExecutablePath = new JTextField();
        phantomJsExecutablePanel.add(this.phantomJsExecutablePath);
        browserPanel.add((Component)phantomJsExecutablePanel);
        VerticalPanel phantomJsCliArgsPanel = new VerticalPanel();
        JLabel phantomJsCliArgsLabel = new JLabel("value for phantomjs.cli.args (comma separator) likes --web-security=false, --ignore-ssl-errors=true");
        phantomJsCliArgsPanel.add(phantomJsCliArgsLabel);
        this.phantomJsCliArgs = new JTextField();
        phantomJsCliArgsPanel.add(this.phantomJsCliArgs);
        browserPanel.add((Component)phantomJsCliArgsPanel);
        VerticalPanel phantomJsGhostdriverCliArgsPanel = new VerticalPanel();
        JLabel phantomJsGhostdriverCliArgsLabel = new JLabel("value for phantomjs.ghostdriver.cli.args (comma separator)");
        phantomJsGhostdriverCliArgsPanel.add(phantomJsGhostdriverCliArgsLabel);
        this.phantomJsGhostdriverCliArgs = new JTextField();
        phantomJsGhostdriverCliArgsPanel.add(this.phantomJsGhostdriverCliArgs);
        browserPanel.add((Component)phantomJsGhostdriverCliArgsPanel);
        return browserPanel;
    }
}

