/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmeter.plugins.webdriver.config;

import com.googlecode.jmeter.plugins.webdriver.config.WebDriverConfig;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import kg.apc.jmeter.JMeterPluginsUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.remote.DesiredCapabilities;

public class FirefoxDriverConfig
extends WebDriverConfig<FirefoxDriver> {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 100L;
    private static final String GENERAL_USERAGENT_OVERRIDE = "FirefoxDriverConfig.general.useragent.override";
    private static final String ENABLE_USERAGENT_OVERRIDE = "FirefoxDriverConfig.general.useragent.override.enabled";
    private static final String ENABLE_NTML = "FirefoxDriverConfig.network.negotiate-auth.allow-insecure-ntlm-v1";
    private static final String EXTENSIONS_TO_LOAD = "FirefoxDriverConfig.general.extensions";
    private static final String PREFERENCES = "FirefoxDriverConfig.general.preferences";

    Capabilities createCapabilities() {
        DesiredCapabilities capabilities = new DesiredCapabilities();
        capabilities.setCapability("proxy", (Object)this.createProxy());
        return capabilities;
    }

    FirefoxProfile createProfile() {
        String ntlmOverride;
        FirefoxProfile profile = new FirefoxProfile();
        profile.setPreference("app.update.enabled", false);
        String userAgentOverride = this.getUserAgentOverride();
        if (StringUtils.isNotEmpty((CharSequence)userAgentOverride)) {
            profile.setPreference("general.useragent.override", userAgentOverride);
        }
        if (StringUtils.isNotEmpty((CharSequence)(ntlmOverride = this.getNtlmSetting()))) {
            profile.setPreference("network.negotiate-auth.allow-insecure-ntlm-v1", true);
        }
        this.addExtensions(profile);
        this.setPreferences(profile);
        return profile;
    }

    private void addExtensions(FirefoxProfile profile) {
        JMeterProperty property = this.getProperty(EXTENSIONS_TO_LOAD);
        if (property instanceof NullProperty) {
            return;
        }
        CollectionProperty rows = (CollectionProperty)property;
        for (int i = 0; i < rows.size(); ++i) {
            ArrayList row = (ArrayList)rows.get(i).getObjectValue();
            String filename = ((JMeterProperty)row.get(0)).getStringValue();
            try {
                profile.addExtension(new File(filename));
                continue;
            }
            catch (IOException e) {
                log.error("Failed to add extension " + filename, (Throwable)e);
            }
        }
    }

    private void setPreferences(FirefoxProfile profile) {
        JMeterProperty property = this.getProperty(PREFERENCES);
        if (property instanceof NullProperty) {
            return;
        }
        CollectionProperty rows = (CollectionProperty)property;
        block8: for (int i = 0; i < rows.size(); ++i) {
            String value;
            ArrayList row = (ArrayList)rows.get(i).getObjectValue();
            String name = ((JMeterProperty)row.get(0)).getStringValue();
            switch (value = ((JMeterProperty)row.get(1)).getStringValue()) {
                case "true": {
                    profile.setPreference(name, true);
                    continue block8;
                }
                case "false": {
                    profile.setPreference(name, false);
                    continue block8;
                }
                default: {
                    profile.setPreference(name, value);
                }
            }
        }
    }

    @Override
    protected FirefoxDriver createBrowser() {
        return new FirefoxDriver(new FirefoxBinary(), this.createProfile(), this.createCapabilities());
    }

    public void setUserAgentOverride(String userAgent) {
        this.setProperty(GENERAL_USERAGENT_OVERRIDE, userAgent);
    }

    public String getUserAgentOverride() {
        return this.getPropertyAsString(GENERAL_USERAGENT_OVERRIDE);
    }

    public boolean isUserAgentOverridden() {
        return this.getPropertyAsBoolean(ENABLE_USERAGENT_OVERRIDE);
    }

    public void setUserAgentOverridden(boolean userAgentOverridden) {
        this.setProperty(ENABLE_USERAGENT_OVERRIDE, userAgentOverridden);
    }

    public void setNtlmSetting(boolean ntlm) {
        this.setProperty(ENABLE_NTML, ntlm);
    }

    public String getNtlmSetting() {
        return this.getPropertyAsString(ENABLE_NTML);
    }

    public void setExtensions(PowerTableModel model) {
        CollectionProperty prop = JMeterPluginsUtils.tableModelRowsToCollectionProperty(model, EXTENSIONS_TO_LOAD);
        this.setProperty((JMeterProperty)prop);
    }

    public void setPreferences(PowerTableModel model) {
        CollectionProperty prop = JMeterPluginsUtils.tableModelRowsToCollectionProperty(model, PREFERENCES);
        this.setProperty((JMeterProperty)prop);
    }

    public JMeterProperty getExtensions() {
        return this.getProperty(EXTENSIONS_TO_LOAD);
    }

    public JMeterProperty getPreferences() {
        return this.getProperty(PREFERENCES);
    }
}

