/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmeter.plugins.webdriver.config;

import com.googlecode.jmeter.plugins.webdriver.proxy.ProxyFactory;
import com.googlecode.jmeter.plugins.webdriver.proxy.ProxyHostPort;
import com.googlecode.jmeter.plugins.webdriver.proxy.ProxyType;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.engine.event.LoopIterationListener;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.SessionNotFoundException;

public abstract class WebDriverConfig<T extends WebDriver>
extends ConfigTestElement
implements LoopIterationListener,
ThreadListener {
    private static final long serialVersionUID = 100L;
    private static final Logger LOGGER = LoggingManager.getLoggerForClass();
    public static final String BROWSER = "Browser";
    private static final Map<String, WebDriver> webdrivers = new ConcurrentHashMap<String, WebDriver>();
    private static final String PROXY_PAC_URL = "WebDriverConfig.proxy_pac_url";
    private static final String HTTP_HOST = "WebDriverConfig.http_host";
    private static final String HTTP_PORT = "WebDriverConfig.http_port";
    private static final String USE_HTTP_FOR_ALL_PROTOCOLS = "WebDriverConfig.use_http_for_all_protocols";
    private static final String HTTPS_HOST = "WebDriverConfig.https_host";
    private static final String HTTPS_PORT = "WebDriverConfig.https_port";
    private static final String FTP_HOST = "WebDriverConfig.ftp_host";
    private static final String FTP_PORT = "WebDriverConfig.ftp_port";
    private static final String SOCKS_HOST = "WebDriverConfig.socks_host";
    private static final String SOCKS_PORT = "WebDriverConfig.socks_port";
    private static final String NO_PROXY = "WebDriverConfig.no_proxy";
    private static final String PROXY_TYPE = "WebDriverConfig.proxy_type";
    private static final String MAXIMIZE_WINDOW = "WebDriverConfig.maximize_browser";
    private static final String RECREATE_ON_ITERATION_START = "WebDriverConfig.reset_per_iteration";
    private static final String DEV_MODE = "WebDriverConfig.dev_mode";
    private final transient ProxyFactory proxyFactory;

    protected WebDriverConfig() {
        this(ProxyFactory.getInstance());
    }

    protected WebDriverConfig(ProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    public void setProxyPacUrl(String pacUrl) {
        this.setProperty(PROXY_PAC_URL, pacUrl);
    }

    public String getProxyPacUrl() {
        return this.getPropertyAsString(PROXY_PAC_URL);
    }

    public void setHttpHost(String host) {
        this.setProperty(HTTP_HOST, host);
    }

    public String getHttpHost() {
        return this.getPropertyAsString(HTTP_HOST);
    }

    public void setHttpPort(int port) {
        this.setProperty(HTTP_PORT, port);
    }

    public int getHttpPort() {
        return this.getPropertyAsInt(HTTP_PORT);
    }

    public void setUseHttpSettingsForAllProtocols(boolean override) {
        this.setProperty(USE_HTTP_FOR_ALL_PROTOCOLS, override);
    }

    public boolean isUseHttpSettingsForAllProtocols() {
        return this.getPropertyAsBoolean(USE_HTTP_FOR_ALL_PROTOCOLS, true);
    }

    public void setHttpsHost(String httpsHost) {
        this.setProperty(HTTPS_HOST, httpsHost);
    }

    public String getHttpsHost() {
        return this.getPropertyAsString(HTTPS_HOST);
    }

    public void setHttpsPort(int port) {
        this.setProperty(HTTPS_PORT, port);
    }

    public int getHttpsPort() {
        return this.getPropertyAsInt(HTTPS_PORT);
    }

    public void setFtpHost(String host) {
        this.setProperty(FTP_HOST, host);
    }

    public String getFtpHost() {
        return this.getPropertyAsString(FTP_HOST);
    }

    public void setFtpPort(int port) {
        this.setProperty(FTP_PORT, port);
    }

    public int getFtpPort() {
        return this.getPropertyAsInt(FTP_PORT);
    }

    public void setSocksHost(String host) {
        this.setProperty(SOCKS_HOST, host);
    }

    public String getSocksHost() {
        return this.getPropertyAsString(SOCKS_HOST);
    }

    public void setSocksPort(int port) {
        this.setProperty(SOCKS_PORT, port);
    }

    public int getSocksPort() {
        return this.getPropertyAsInt(SOCKS_PORT);
    }

    public void setNoProxyHost(String noProxyHostList) {
        this.setProperty(NO_PROXY, noProxyHostList);
    }

    public String getNoProxyHost() {
        return this.getPropertyAsString(NO_PROXY);
    }

    public void setProxyType(ProxyType type) {
        this.setProperty(PROXY_TYPE, type.name());
    }

    public ProxyType getProxyType() {
        return ProxyType.valueOf(this.getPropertyAsString(PROXY_TYPE, ProxyType.SYSTEM.name()));
    }

    public boolean isBrowserMaximized() {
        return this.getPropertyAsBoolean(MAXIMIZE_WINDOW, false);
    }

    public void setBrowserMaximized(boolean state) {
        this.setProperty(MAXIMIZE_WINDOW, state);
    }

    public Proxy createProxy() {
        switch (this.getProxyType()) {
            case PROXY_PAC: {
                return this.proxyFactory.getConfigUrlProxy(this.getProxyPacUrl());
            }
            case DIRECT: {
                return this.proxyFactory.getDirectProxy();
            }
            case AUTO_DETECT: {
                return this.proxyFactory.getAutodetectProxy();
            }
            case MANUAL: {
                if (this.isUseHttpSettingsForAllProtocols()) {
                    ProxyHostPort proxy = new ProxyHostPort(this.getHttpHost(), this.getHttpPort());
                    return this.proxyFactory.getManualProxy(proxy, proxy, proxy, proxy, this.getNoProxyHost());
                }
                ProxyHostPort http = new ProxyHostPort(this.getHttpHost(), this.getHttpPort());
                ProxyHostPort https = new ProxyHostPort(this.getHttpsHost(), this.getHttpsPort());
                ProxyHostPort ftp = new ProxyHostPort(this.getFtpHost(), this.getFtpPort());
                ProxyHostPort socks = new ProxyHostPort(this.getSocksHost(), this.getSocksPort());
                return this.proxyFactory.getManualProxy(http, https, ftp, socks, this.getNoProxyHost());
            }
        }
        return this.proxyFactory.getSystemProxy();
    }

    public void iterationStart(LoopIterationEvent loopIterationEvent) {
        if (this.isRecreateBrowserOnIterationStart() && !this.isDevMode()) {
            T browser = this.getThreadBrowser();
            this.quitBrowser(browser);
            this.setThreadBrowser(this.getPreparedBrowser());
            LOGGER.info("Created browser object: " + browser);
        }
        this.getThreadContext().getVariables().putObject(BROWSER, this.getThreadBrowser());
    }

    public void threadStarted() {
        if (this.hasThreadBrowser()) {
            LOGGER.warn("Thread: " + this.currentThreadName() + " already has a WebDriver(" + this.getThreadBrowser() + ") associated with it. ThreadGroup can only contain a single WebDriverConfig.");
            return;
        }
        T browser = this.getPreparedBrowser();
        this.setThreadBrowser(browser);
        Runtime.getRuntime().addShutdownHook(new Thread((WebDriver)browser){
            final /* synthetic */ WebDriver val$browser;
            {
                this.val$browser = webDriver;
            }

            @Override
            public void run() {
                WebDriverConfig.this.quitBrowser(this.val$browser);
            }
        });
    }

    private T getPreparedBrowser() {
        T browser = this.createBrowser();
        if (this.isBrowserMaximized()) {
            browser.manage().window().maximize();
        }
        return browser;
    }

    public void threadFinished() {
        if (!this.isDevMode()) {
            T browser = this.removeThreadBrowser();
            this.quitBrowser(browser);
        }
    }

    protected String currentThreadName() {
        return Thread.currentThread().getName();
    }

    protected abstract T createBrowser();

    protected void quitBrowser(T browser) {
        if (browser != null) {
            try {
                browser.quit();
            }
            catch (SessionNotFoundException e) {
                LOGGER.warn("Attempting to quit browser instance that has already exited.");
            }
        }
    }

    protected T getThreadBrowser() {
        return (T)webdrivers.get(this.currentThreadName());
    }

    protected boolean hasThreadBrowser() {
        if (webdrivers.containsKey(this.currentThreadName())) {
            WebDriver browser = webdrivers.get(this.currentThreadName());
            try {
                browser.getCurrentUrl();
                return true;
            }
            catch (Exception ex) {
                LOGGER.warn("Old browser object is inaccessible, will create new", (Throwable)ex);
                webdrivers.remove(this.currentThreadName());
            }
        }
        return false;
    }

    protected void setThreadBrowser(T browser) {
        if (browser != null) {
            webdrivers.put(this.currentThreadName(), (WebDriver)browser);
        }
    }

    protected T removeThreadBrowser() {
        return (T)webdrivers.remove(this.currentThreadName());
    }

    void clearThreadBrowsers() {
        webdrivers.clear();
    }

    Map<String, WebDriver> getThreadBrowsers() {
        return webdrivers;
    }

    public boolean isRecreateBrowserOnIterationStart() {
        return this.getPropertyAsBoolean(RECREATE_ON_ITERATION_START);
    }

    public void setRecreateBrowserOnIterationStart(boolean recreate) {
        this.setProperty(RECREATE_ON_ITERATION_START, recreate);
    }

    public boolean isDevMode() {
        return this.getPropertyAsBoolean(DEV_MODE);
    }

    public void setDevMode(boolean devMode) {
        this.setProperty(DEV_MODE, devMode);
    }
}

