/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmeter.plugins.webdriver.config.gui;

import com.googlecode.jmeter.plugins.webdriver.config.RemoteCapability;
import com.googlecode.jmeter.plugins.webdriver.config.RemoteDriverConfig;
import com.googlecode.jmeter.plugins.webdriver.config.gui.WebDriverConfigGui;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kg.apc.jmeter.JMeterPluginsUtils;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.TestElement;

public class RemoteDriverConfigGui
extends WebDriverConfigGui
implements ItemListener,
FocusListener {
    private static final long serialVersionUID = 100L;
    JTextField remoteSeleniumGridText;
    JComboBox capabilitiesComboBox;
    JLabel errorMsg;

    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel("Remote Driver Config");
    }

    public String getLabelResource() {
        return this.getClass().getCanonicalName();
    }

    @Override
    protected JPanel createBrowserPanel() {
        return this.createProfilePanel();
    }

    @Override
    protected String browserName() {
        return "Remote";
    }

    @Override
    protected String getWikiPage() {
        return "RemoteDriverConfig";
    }

    public TestElement createTestElement() {
        RemoteDriverConfig element = new RemoteDriverConfig();
        this.modifyTestElement((TestElement)element);
        return element;
    }

    @Override
    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof RemoteDriverConfig) {
            RemoteDriverConfig config = (RemoteDriverConfig)element;
            this.remoteSeleniumGridText.setText(config.getSeleniumGridUrl());
            this.capabilitiesComboBox.setSelectedItem((Object)config.getCapability());
        }
    }

    @Override
    public void modifyTestElement(TestElement element) {
        super.modifyTestElement(element);
        if (element instanceof RemoteDriverConfig) {
            RemoteDriverConfig config = (RemoteDriverConfig)element;
            config.setSeleniumGridUrl(this.remoteSeleniumGridText.getText());
            config.setCapability((RemoteCapability)((Object)this.capabilitiesComboBox.getSelectedItem()));
        }
    }

    private JPanel createProfilePanel() {
        VerticalPanel browserPanel = new VerticalPanel();
        VerticalPanel remotePanel = new VerticalPanel();
        JLabel remoteUrlLabel = new JLabel();
        JLabel capabilitiesLabel = new JLabel();
        remoteUrlLabel.setText("Selenium Grid URL");
        this.remoteSeleniumGridText = new JTextField();
        this.remoteSeleniumGridText.setEnabled(true);
        this.remoteSeleniumGridText.addFocusListener(this);
        capabilitiesLabel.setText("Capability");
        this.capabilitiesComboBox = new JComboBox<RemoteCapability>(RemoteCapability.values());
        remotePanel.add(remoteUrlLabel);
        remotePanel.add(this.remoteSeleniumGridText);
        this.errorMsg = new JLabel();
        remotePanel.add(this.errorMsg);
        remotePanel.add(capabilitiesLabel);
        remotePanel.add(this.capabilitiesComboBox);
        this.errorMsg.setForeground(Color.red);
        browserPanel.add((Component)remotePanel);
        return browserPanel;
    }

    @Override
    public void clearGui() {
        super.clearGui();
        this.remoteSeleniumGridText.setText("");
        this.capabilitiesComboBox.setSelectedIndex(2);
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.remoteSeleniumGridText.equals(e.getComponent()) && !this.isValidUrl(this.remoteSeleniumGridText.getText())) {
            this.errorMsg.setText("The selenium grid URL is malformed");
        } else {
            this.errorMsg.setText("");
        }
    }

    private boolean isValidUrl(String urlStr) {
        try {
            new URL(urlStr);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    @Override
    protected boolean isProxyEnabled() {
        return false;
    }

    @Override
    protected boolean isExperimentalEnabled() {
        return false;
    }
}

