/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmeter.plugins.webdriver.sampler.gui;

import com.googlecode.jmeter.plugins.webdriver.sampler.WebDriverSampler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jsyntaxpane.DefaultSyntaxKit;
import kg.apc.jmeter.JMeterPluginsUtils;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JSR223BeanInfoSupport;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class WebDriverSamplerGui
extends AbstractSamplerGui {
    private static final long serialVersionUID = 100L;
    private static final Logger LOGGER = LoggingManager.getLoggerForClass();
    JTextField parameters;
    JEditorPane script;
    JComboBox<String> languages;

    public WebDriverSamplerGui() {
        this.createGui();
    }

    public String getStaticLabel() {
        return JMeterPluginsUtils.prefixLabel("WebDriver Sampler");
    }

    public String getLabelResource() {
        return ((Object)((Object)this)).getClass().getCanonicalName();
    }

    public void configure(TestElement element) {
        this.script.setText(element.getPropertyAsString("WebDriverSampler.script"));
        this.parameters.setText(element.getPropertyAsString("WebDriverSampler.parameters"));
        this.languages.setSelectedItem(element.getPropertyAsString("WebDriverSampler.language"));
        super.configure(element);
    }

    public TestElement createTestElement() {
        WebDriverSampler sampler = new WebDriverSampler();
        this.modifyTestElement((TestElement)sampler);
        return sampler;
    }

    public void modifyTestElement(TestElement element) {
        element.clear();
        this.configureTestElement(element);
        element.setProperty("WebDriverSampler.script", this.script.getText());
        element.setProperty("WebDriverSampler.parameters", this.parameters.getText());
        element.setProperty("WebDriverSampler.language", (String)this.languages.getSelectedItem());
    }

    public void clearGui() {
        super.clearGui();
        this.parameters.setText("");
        this.script.setText("WDS.sampleResult.sampleStart()\nWDS.browser.get('http://jmeter-plugins.org')\nWDS.sampleResult.sampleEnd()\n");
        this.languages.setSelectedItem("javascript");
    }

    private void createGui() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        Box box = Box.createVerticalBox();
        box.add(JMeterPluginsUtils.addHelpLinkToPanel(this.makeTitlePanel(), "WebDriverSampler"));
        box.add(this.createParameterPanel());
        box.add(this.createLangPanel());
        this.add(box, "North");
        JPanel panel = this.createScriptPanel();
        this.add(panel, "Center");
        this.add(Box.createVerticalStrut(panel.getPreferredSize().height), "West");
    }

    private JPanel createParameterPanel() {
        JLabel label = new JLabel("Parameters:");
        this.parameters = new JTextField(10);
        this.parameters.setName("WebDriverSampler.parameters");
        label.setLabelFor(this.parameters);
        JPanel parameterPanel = new JPanel(new BorderLayout(5, 0));
        parameterPanel.add((Component)label, "West");
        parameterPanel.add((Component)this.parameters, "Center");
        return parameterPanel;
    }

    private JPanel createLangPanel() {
        JLabel label = new JLabel("Script Language:");
        String[][] languageNames = JSR223BeanInfoSupport.LANGUAGE_NAMES;
        String[] langs = new String[languageNames.length];
        for (int n = 0; n < languageNames.length; ++n) {
            langs[n] = languageNames[n][0];
        }
        this.languages = new JComboBox<String>(langs);
        this.languages.setName("WebDriverSampler.parameters");
        label.setLabelFor(this.languages);
        this.languages.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox source = (JComboBox)actionEvent.getSource();
                String ctype = "text/" + source.getSelectedItem();
                WebDriverSamplerGui.this.setScriptContentType(ctype);
            }
        });
        JPanel parameterPanel = new JPanel(new BorderLayout(5, 0));
        parameterPanel.add((Component)label, "West");
        parameterPanel.add(this.languages, "Center");
        return parameterPanel;
    }

    private void setScriptContentType(String ctype) {
        String text = this.script.getText();
        this.script.setContentType(ctype);
        this.script.setText(text);
    }

    private JPanel createScriptPanel() {
        this.script = new JEditorPane();
        JScrollPane scrollPane = new JScrollPane(this.script);
        this.setScriptContentType("text/plain");
        this.script.setFont(new Font("Monospaced", 0, 14));
        JLabel label = new JLabel("Script (see below for variables that are defined)");
        label.setLabelFor(this.script);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)label, "North");
        panel.add((Component)scrollPane, "Center");
        JTextArea explain = new JTextArea("The following variables are defined for the script: WDS.name, WDS.parameters, WDS.args, WDS.log, WDS.browser, WDS.sampleResult");
        explain.setLineWrap(true);
        explain.setEditable(false);
        explain.setBackground(this.getBackground());
        panel.add((Component)explain, "South");
        return panel;
    }

    static {
        if (!GraphicsEnvironment.getLocalGraphicsEnvironment().isHeadlessInstance()) {
            DefaultSyntaxKit.initKit();
        } else {
            LOGGER.info("Headless environment detected. Disabling JSyntaxPane highlighting.");
        }
    }
}

