/*
 * Decompiled with CFR 0.152.
 */
package me.dinowernli.grpc.prometheus;

import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.Status;
import java.time.Clock;
import java.time.Instant;
import me.dinowernli.grpc.prometheus.Configuration;
import me.dinowernli.grpc.prometheus.GrpcMethod;
import me.dinowernli.grpc.prometheus.ServerMetrics;

class MonitoringServerCall<R, S>
extends ForwardingServerCall.SimpleForwardingServerCall<R, S> {
    private static final long MILLIS_PER_SECOND = 1000L;
    private final Clock clock;
    private final GrpcMethod grpcMethod;
    private final ServerMetrics serverMetrics;
    private final Configuration configuration;
    private final Instant startInstant;
    private final Metadata requestMetadata;

    MonitoringServerCall(ServerCall<R, S> delegate, Clock clock, GrpcMethod grpcMethod, ServerMetrics serverMetrics, Configuration configuration, Metadata requestMetadata) {
        super(delegate);
        this.clock = clock;
        this.grpcMethod = grpcMethod;
        this.serverMetrics = serverMetrics;
        this.configuration = configuration;
        this.startInstant = clock.instant();
        this.requestMetadata = requestMetadata;
        this.reportStartMetrics();
    }

    public void close(Status status, Metadata responseHeaders) {
        this.reportEndMetrics(status);
        super.close(status, responseHeaders);
    }

    public void sendMessage(S message) {
        if (this.grpcMethod.streamsResponses()) {
            this.serverMetrics.recordStreamMessageSent(this.requestMetadata);
        }
        super.sendMessage(message);
    }

    private void reportStartMetrics() {
        this.serverMetrics.recordCallStarted(this.requestMetadata);
    }

    private void reportEndMetrics(Status status) {
        Status.Code code = status.getCode();
        this.serverMetrics.recordServerHandled(code, this.requestMetadata);
        if (this.configuration.isIncludeLatencyHistograms()) {
            double latencySec = (double)(this.clock.millis() - this.startInstant.toEpochMilli()) / 1000.0;
            this.serverMetrics.recordLatency(latencySec, this.requestMetadata, code);
        }
    }
}

