/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.maven.plugin.surefire.report.TestSetStats;
import org.apache.maven.plugin.surefire.report.TreePrinter;
import org.apache.maven.plugin.surefire.report.WrappedReportEntry;
import org.apache.maven.surefire.api.report.ReportEntry;

public class TestReportHandler {
    protected static final Map<String, Set<String>> classNames = Collections.synchronizedMap(new HashMap());
    protected static final Map<String, List<WrappedReportEntry>> classEntries = Collections.synchronizedMap(new HashMap());
    protected static final Map<String, List<WrappedReportEntry>> testEntries = Collections.synchronizedMap(new HashMap());
    protected static final int $ = 36;
    private final ReportEntry report;
    private final TestSetStats testSetStats;
    private final String sourceRootName;

    public TestReportHandler(ReportEntry report, TestSetStats testSetStats) {
        this.report = report;
        this.testSetStats = testSetStats;
        this.sourceRootName = this.getSourceRootName();
    }

    public TestReportHandler(ReportEntry report) {
        this(report, null);
    }

    public void prepare() {
        if (this.hasNestedTests()) {
            this.markClassNamesForNestedTests();
        }
    }

    public void print(BiFunction<List<WrappedReportEntry>, List<WrappedReportEntry>, TreePrinter> getTreePrinter) {
        if (this.isMarkedAsNestedTest()) {
            this.prepareEntriesForNestedTests();
            if (this.isNestedTestReadyToPrint()) {
                this.printNestedTests(getTreePrinter);
            }
        } else {
            this.printTests(getTreePrinter);
        }
    }

    private boolean isMarkedAsNestedTest() {
        return classNames.containsKey(this.sourceRootName);
    }

    private void prepareClassEntriesForNestedTest() {
        classEntries.putIfAbsent(this.sourceRootName, new ArrayList());
        classEntries.computeIfPresent(this.sourceRootName, this.addToCollection((WrappedReportEntry)this.report));
    }

    private List<WrappedReportEntry> getClassEntryList() {
        return classEntries.get(this.sourceRootName);
    }

    private void markClassNamesForNestedTests() {
        classNames.putIfAbsent(this.sourceRootName, new HashSet<String>(Collections.singleton(this.sourceRootName)));
        classNames.computeIfPresent(this.sourceRootName, this.addToCollection(this.report.getSourceName()));
    }

    private Set<String> getClassNameList() {
        return classNames.get(this.sourceRootName);
    }

    private void prepareTestEntriesForNestedTest() {
        testEntries.putIfAbsent(this.sourceRootName, new ArrayList(this.testSetStats.getReportEntries()));
    }

    private List<WrappedReportEntry> getTestEntryList() {
        return testEntries.get(this.sourceRootName);
    }

    private void cleanEntries() {
        classNames.remove(this.sourceRootName);
        classEntries.remove(this.sourceRootName);
        testEntries.remove(this.sourceRootName);
    }

    private void sortClassEntryList() {
        this.getClassEntryList().sort(Comparator.comparing(ReportEntry::getSourceName));
    }

    private void prepareEntriesForNestedTests() {
        if (this.hasNestedTests()) {
            this.prepareTestEntriesForNestedTest();
        }
        this.prepareClassEntriesForNestedTest();
    }

    private boolean isNestedTestReadyToPrint() {
        return this.getClassEntryList().size() == this.getClassNameList().size();
    }

    private void printNestedTests(BiFunction<List<WrappedReportEntry>, List<WrappedReportEntry>, TreePrinter> getTreePrinter) {
        this.sortClassEntryList();
        getTreePrinter.apply(this.getClassEntryList(), this.getTestEntryList()).printTests();
        this.cleanEntries();
    }

    private void printTests(BiFunction<List<WrappedReportEntry>, List<WrappedReportEntry>, TreePrinter> getTreePrinter) {
        getTreePrinter.apply(Collections.singletonList((WrappedReportEntry)this.report), new ArrayList(this.testSetStats.getReportEntries())).printTests();
    }

    private <J, K, V extends Collection<K>> BiFunction<J, V, V> addToCollection(K obj) {
        return (k, v) -> {
            v.add(obj);
            return v;
        };
    }

    private String getSourceRootName() {
        return this.report.getSourceName().split("\\$", -1)[0];
    }

    private boolean hasNestedTests() {
        if (this.testSetStats == null) {
            return this.hasNestedTests(this.report);
        }
        return this.hasNestedTests(this.testSetStats);
    }

    private boolean hasNestedTests(TestSetStats testSetStats) {
        return testSetStats.getReportEntries().stream().anyMatch(this::hasNestedTests);
    }

    private boolean hasNestedTests(ReportEntry reportEntry) {
        return reportEntry.getSourceName().chars().filter(c -> c == 36).count() > 0L;
    }
}

