/*
 * Decompiled with CFR 0.152.
 */
package me.madhead.aws_junit5.common.v1;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.util.StringUtils;
import java.lang.reflect.Field;
import me.madhead.aws_junit5.common.AWSClient;
import me.madhead.aws_junit5.common.AWSEndpoint;
import me.madhead.aws_junit5.common.v1.AWSAdvancedConfiguration;

public final class AWSClientFactory<S extends AwsClientBuilder<S, T>, T>
implements me.madhead.aws_junit5.common.impl.AWSClientFactory<T> {
    private final AwsClientBuilder<S, T> awsClientBuilder;

    public AWSClientFactory(AwsClientBuilder<S, T> awsClientBuilder) {
        this.awsClientBuilder = awsClientBuilder;
    }

    public T client(Field field) throws Exception {
        AWSAdvancedConfiguration awsAdvancedConfiguration;
        ClientConfiguration clientConfiguration;
        AWSClient awsClientAnnotation = field.getAnnotation(AWSClient.class);
        AWSEndpoint endpoint = (AWSEndpoint)awsClientAnnotation.endpoint().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.validate(endpoint);
        AwsClientBuilder awsClientBuilder = this.awsClientBuilder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpoint.url(), endpoint.region())).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(endpoint.accessKey(), endpoint.secretKey())));
        if (field.isAnnotationPresent(AWSAdvancedConfiguration.class) && (clientConfiguration = (awsAdvancedConfiguration = field.getAnnotation(AWSAdvancedConfiguration.class)).clientConfigurationFactory().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).create()) != null) {
            awsClientBuilder.withClientConfiguration(clientConfiguration);
        }
        return (T)awsClientBuilder.build();
    }

    private void validate(AWSEndpoint clientConfiguration) {
        if (StringUtils.isNullOrEmpty((String)clientConfiguration.url())) {
            throw new IllegalArgumentException("Missing URL");
        }
    }
}

