/*
 * Decompiled with CFR 0.152.
 */
package me.normanmaurer.maven.autobahntestsuite;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.normanmaurer.maven.autobahntestsuite.FuzzingCaseResult;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.python.core.PyArray;
import org.python.core.PyBoolean;
import org.python.core.PyDictionary;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.util.PythonInterpreter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutobahnTestSuite {
    static final String OUTDIR = "target/autobahntestsuite-reports";
    private static final OutputStream DEV_NULL = new DevNullOutputStream();

    public static List<FuzzingCaseResult> runFuzzingClient(String agent, String url, Map options, List<String> cases, List<String> excludeCases) {
        PythonInterpreter interp = new PythonInterpreter();
        interp.setErr(DEV_NULL);
        interp.exec("import sys");
        interp.exec("from autobahntestsuite import wstest");
        PyDictionary opts = new PyDictionary();
        opts.__setitem__((PyObject)new PyString("mode"), (PyObject)new PyString("fuzzingclient"));
        interp.set("opts", (PyObject)opts);
        PyDictionary spec = AutobahnTestSuite.createFuzzingClientSpec(agent, url, options, cases, excludeCases);
        interp.set("spec", (PyObject)spec);
        interp.exec("wstest.start(opts, spec)");
        try {
            List<FuzzingCaseResult> results = AutobahnTestSuite.parseResults(agent);
            if (results == null) {
                throw new IllegalStateException("No results");
            }
            return results;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static PyDictionary createFuzzingClientSpec(String agent, String url, Map options, List<String> cases, List<String> excludeCases) {
        PyDictionary dict = new PyDictionary();
        dict.__setitem__((PyObject)new PyString("failByDrop"), (PyObject)new PyBoolean(false));
        dict.__setitem__((PyObject)new PyString("outdir"), (PyObject)new PyString(OUTDIR));
        PyDictionary server = new PyDictionary();
        server.__setitem__((PyObject)new PyString("agent"), (PyObject)new PyString(agent));
        server.__setitem__((PyObject)new PyString("url"), (PyObject)new PyString(url));
        dict.__setitem__((PyObject)new PyString("servers"), (PyObject)new PyArray(PyDictionary.class, (Object)new PyDictionary[]{server}));
        PyDictionary opts = new PyDictionary();
        opts.putAll(options);
        dict.__setitem__((PyObject)new PyString("options"), (PyObject)opts);
        dict.__setitem__((PyObject)new PyString("cases"), (PyObject)new PyArray(String.class, (Object)cases.toArray(new String[cases.size()])));
        dict.__setitem__((PyObject)new PyString("exclude-cases"), (PyObject)new PyArray(PyString.class, (Object)excludeCases.toArray(new String[excludeCases.size()])));
        return dict;
    }

    private static List<FuzzingCaseResult> parseResults(String agentString) throws Exception {
        ArrayList<FuzzingCaseResult> results = new ArrayList<FuzzingCaseResult>();
        JSONParser parser = new JSONParser();
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(new FileInputStream("target/autobahntestsuite-reports/index.json"));
            JSONObject object = (JSONObject)parser.parse((Reader)reader);
            JSONObject agent = (JSONObject)object.get((Object)agentString);
            if (agent == null) {
                List<FuzzingCaseResult> list = null;
                return list;
            }
            for (Object cases : agent.keySet()) {
                JSONObject c = (JSONObject)agent.get(cases);
                String behavior = (String)c.get((Object)"behavior");
                String behaviorClose = (String)c.get((Object)"behaviorClose");
                Number duration = (Number)c.get((Object)"duration");
                Number remoteCloseCode = (Number)c.get((Object)"remoteCloseCode");
                Long code = remoteCloseCode == null ? null : Long.valueOf(remoteCloseCode.longValue());
                String reportfile = (String)c.get((Object)"reportfile");
                FuzzingCaseResult result = new FuzzingCaseResult(cases.toString(), FuzzingCaseResult.Behavior.parse(behavior), FuzzingCaseResult.Behavior.parse(behaviorClose), duration.longValue(), code, OUTDIR + File.separator + reportfile);
                results.add(result);
            }
        }
        catch (Exception e) {
            throw new Exception("Could not parse results", e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return results;
    }

    private static final class DevNullOutputStream
    extends OutputStream {
        private DevNullOutputStream() {
        }

        public void write(int b) throws IOException {
        }
    }
}

