
package me.snowdrop.istio.client.internal.handler.security.v1beta1;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;

import okhttp3.OkHttpClient;


import me.snowdrop.istio.client.internal.operation.security.v1beta1.AuthorizationPolicyOperationImpl;

import me.snowdrop.istio.api.security.v1beta1.AuthorizationPolicy;
import me.snowdrop.istio.api.security.v1beta1.AuthorizationPolicyBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class AuthorizationPolicyHandler implements ResourceHandler<AuthorizationPolicy, AuthorizationPolicyBuilder> {

  @Override
  public String getKind() {
    return AuthorizationPolicy.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "security.istio.io/v1beta1";
    }

  @Override
public AuthorizationPolicy create(OkHttpClient client, Config config, String namespace, AuthorizationPolicy item) {
return new AuthorizationPolicyOperationImpl(client, config).withItem(item).inNamespace(namespace).create();
}

@Override
public AuthorizationPolicy replace(OkHttpClient client, Config config, String namespace, AuthorizationPolicy item) {
return new AuthorizationPolicyOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
}

@Override
public AuthorizationPolicy reload(OkHttpClient client, Config config, String namespace, AuthorizationPolicy item) {
return new AuthorizationPolicyOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
}

@Override
public AuthorizationPolicyBuilder edit(AuthorizationPolicy item) {
return new AuthorizationPolicyBuilder(item);
}

@Override
public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, AuthorizationPolicy item) {
return new AuthorizationPolicyOperationImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, AuthorizationPolicy item, Watcher<AuthorizationPolicy> watcher) {
return new AuthorizationPolicyOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, AuthorizationPolicy item, String resourceVersion, Watcher<AuthorizationPolicy> watcher) {
return new AuthorizationPolicyOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, AuthorizationPolicy item, ListOptions listOptions, final Watcher<AuthorizationPolicy> watcher) {
return new AuthorizationPolicyOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
}

@Override
public AuthorizationPolicy waitUntilReady(OkHttpClient client, Config config, String namespace, AuthorizationPolicy item, long amount, TimeUnit timeUnit) throws InterruptedException {
return new AuthorizationPolicyOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
}

@Override
public AuthorizationPolicy waitUntilCondition(OkHttpClient client, Config config, String namespace, AuthorizationPolicy item, Predicate<AuthorizationPolicy> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new AuthorizationPolicyOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
