
package me.snowdrop.istio.client.internal.handler.security.v1beta1;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;

import okhttp3.OkHttpClient;


import me.snowdrop.istio.client.internal.operation.security.v1beta1.RequestAuthenticationOperationImpl;

import me.snowdrop.istio.api.security.v1beta1.RequestAuthentication;
import me.snowdrop.istio.api.security.v1beta1.RequestAuthenticationBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class RequestAuthenticationHandler implements ResourceHandler<RequestAuthentication, RequestAuthenticationBuilder> {

  @Override
  public String getKind() {
    return RequestAuthentication.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "security.istio.io/v1beta1";
    }

  @Override
public RequestAuthentication create(OkHttpClient client, Config config, String namespace, RequestAuthentication item) {
return new RequestAuthenticationOperationImpl(client, config).withItem(item).inNamespace(namespace).create();
}

@Override
public RequestAuthentication replace(OkHttpClient client, Config config, String namespace, RequestAuthentication item) {
return new RequestAuthenticationOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
}

@Override
public RequestAuthentication reload(OkHttpClient client, Config config, String namespace, RequestAuthentication item) {
return new RequestAuthenticationOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
}

@Override
public RequestAuthenticationBuilder edit(RequestAuthentication item) {
return new RequestAuthenticationBuilder(item);
}

@Override
public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, RequestAuthentication item) {
return new RequestAuthenticationOperationImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, RequestAuthentication item, Watcher<RequestAuthentication> watcher) {
return new RequestAuthenticationOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, RequestAuthentication item, String resourceVersion, Watcher<RequestAuthentication> watcher) {
return new RequestAuthenticationOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
}

@Override
public Watch watch(OkHttpClient client, Config config, String namespace, RequestAuthentication item, ListOptions listOptions, final Watcher<RequestAuthentication> watcher) {
return new RequestAuthenticationOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
}

@Override
public RequestAuthentication waitUntilReady(OkHttpClient client, Config config, String namespace, RequestAuthentication item, long amount, TimeUnit timeUnit) throws InterruptedException {
return new RequestAuthenticationOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
}

@Override
public RequestAuthentication waitUntilCondition(OkHttpClient client, Config config, String namespace, RequestAuthentication item, Predicate<RequestAuthentication> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new RequestAuthenticationOperationImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
