/*
 * Decompiled with CFR 0.152.
 */
package me.tongfei.progressbar;

import java.time.Duration;
import java.time.Instant;

public class ProgressState {
    String taskName;
    String extraMessage = "";
    boolean indefinite = false;
    long start;
    long current;
    long max;
    Instant startInstant;
    Duration elapsedBeforeStart;
    volatile boolean alive = true;
    volatile boolean paused = false;

    ProgressState(String taskName, long initialMax, long startFrom, Duration elapsedBeforeStart) {
        this.taskName = taskName;
        if (initialMax < 0L) {
            this.indefinite = true;
        } else {
            this.max = initialMax;
        }
        this.start = startFrom;
        this.current = startFrom;
        this.startInstant = Instant.now();
        this.elapsedBeforeStart = elapsedBeforeStart;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public synchronized String getExtraMessage() {
        return this.extraMessage;
    }

    public synchronized long getStart() {
        return this.start;
    }

    public synchronized long getCurrent() {
        return this.current;
    }

    public synchronized long getMax() {
        return this.max;
    }

    public synchronized double getNormalizedProgress() {
        if (this.max <= 0L) {
            return 0.0;
        }
        if (this.current > this.max) {
            return 1.0;
        }
        return (double)this.current / (double)this.max;
    }

    public synchronized Instant getStartInstant() {
        return this.startInstant;
    }

    public synchronized Duration getElapsedBeforeStart() {
        return this.elapsedBeforeStart;
    }

    public synchronized Duration getElapsedAfterStart() {
        return this.startInstant == null ? Duration.ZERO : Duration.between(this.startInstant, Instant.now());
    }

    public synchronized Duration getTotalElapsed() {
        return this.getElapsedBeforeStart().plus(this.getElapsedAfterStart());
    }

    public synchronized boolean isIndefinite() {
        return this.indefinite;
    }

    public synchronized boolean isAlive() {
        return this.alive;
    }

    public synchronized boolean isPaused() {
        return this.paused;
    }

    synchronized void setAsDefinite() {
        this.indefinite = false;
    }

    synchronized void setAsIndefinite() {
        this.indefinite = true;
    }

    synchronized void maxHint(long n) {
        this.max = n;
    }

    synchronized void stepBy(long n) {
        this.current += n;
        if (this.current > this.max) {
            this.max = this.current;
        }
    }

    synchronized void stepTo(long n) {
        this.current = n;
        if (this.current > this.max) {
            this.max = this.current;
        }
    }

    synchronized void setExtraMessage(String msg) {
        this.extraMessage = msg;
    }

    synchronized void pause() {
        this.paused = true;
        this.start = this.current;
        this.elapsedBeforeStart = this.elapsedBeforeStart.plus(Duration.between(this.startInstant, Instant.now()));
    }

    synchronized void resume() {
        this.paused = false;
        this.startInstant = Instant.now();
    }

    synchronized void reset() {
        this.start = 0L;
        this.current = 0L;
        this.startInstant = Instant.now();
        this.elapsedBeforeStart = Duration.ZERO;
    }

    synchronized void kill() {
        this.alive = false;
    }
}

