/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import com.alibaba.fastjson.JSONObject;
import com.xkcoding.http.support.HttpHeader;
import java.util.HashMap;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthDefaultSource;
import me.zhyd.oauth.enums.scope.AuthDingTalkScope;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthDefaultRequest;
import me.zhyd.oauth.utils.AuthScopeUtils;
import me.zhyd.oauth.utils.HttpUtils;
import me.zhyd.oauth.utils.UrlBuilder;

public class AuthDingTalkV2Request
extends AuthDefaultRequest {
    public AuthDingTalkV2Request(AuthConfig config) {
        super(config, AuthDefaultSource.DINGTALK_V2);
    }

    public AuthDingTalkV2Request(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthDefaultSource.DINGTALK_V2, authStateCache);
    }

    @Override
    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("client_id", this.config.getClientId()).queryParam("scope", this.getScopes(",", true, AuthScopeUtils.getDefaultScopes(AuthDingTalkScope.values()))).queryParam("redirect_uri", this.config.getRedirectUri()).queryParam("prompt", "consent").queryParam("org_type", this.config.getDingTalkOrgType()).queryParam("corpId", this.config.getDingTalkCorpId()).queryParam("exclusiveLogin", this.config.isDingTalkExclusiveLogin()).queryParam("exclusiveCorpId", this.config.getDingTalkExclusiveCorpId()).queryParam("state", this.getRealState(state)).build();
    }

    @Override
    public AuthToken getAccessToken(AuthCallback authCallback) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("grantType", "authorization_code");
        params.put("clientId", this.config.getClientId());
        params.put("clientSecret", this.config.getClientSecret());
        params.put("code", authCallback.getCode());
        String response = new HttpUtils(this.config.getHttpConfig()).post(this.source.accessToken(), JSONObject.toJSONString(params)).getBody();
        JSONObject accessTokenObject = JSONObject.parseObject((String)response);
        if (!accessTokenObject.containsKey((Object)"accessToken")) {
            throw new AuthException(JSONObject.toJSONString((Object)response), this.source);
        }
        return AuthToken.builder().accessToken(accessTokenObject.getString("accessToken")).refreshToken(accessTokenObject.getString("refreshToken")).expireIn(accessTokenObject.getIntValue("expireIn")).corpId(accessTokenObject.getString("corpId")).build();
    }

    @Override
    public AuthUser getUserInfo(AuthToken authToken) {
        HttpHeader header = new HttpHeader();
        header.add("x-acs-dingtalk-access-token", authToken.getAccessToken());
        String response = new HttpUtils(this.config.getHttpConfig()).get(this.source.userInfo(), null, header, false).getBody();
        JSONObject object = JSONObject.parseObject((String)response);
        authToken.setOpenId(object.getString("openId"));
        authToken.setUnionId(object.getString("unionId"));
        return AuthUser.builder().rawUserInfo(object).uuid(object.getString("unionId")).username(object.getString("nick")).nickname(object.getString("nick")).avatar(object.getString("avatarUrl")).snapshotUser(object.getBooleanValue("visitor")).token(authToken).source(this.source.toString()).build();
    }

    @Override
    protected String accessTokenUrl(String code) {
        return UrlBuilder.fromBaseUrl(this.source.accessToken()).queryParam("code", code).queryParam("clientId", this.config.getClientId()).queryParam("clientSecret", this.config.getClientSecret()).queryParam("grantType", "authorization_code").build();
    }
}

