/*
 * Decompiled with CFR 0.152.
 */
package net.aichler.jupiter.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.aichler.jupiter.api.JupiterTestListener;
import net.aichler.jupiter.internal.Color;
import net.aichler.jupiter.internal.ColorTheme;
import net.aichler.jupiter.internal.TestLogger;
import net.aichler.jupiter.internal.listeners.FlatPrintingTestListener;
import net.aichler.jupiter.internal.listeners.TreePrintingTestListener;
import net.aichler.jupiter.internal.options.Options;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import sbt.testing.Logger;

public class Configuration {
    private final Options options;
    private final TestLogger logger;
    private final ColorTheme colorTheme = new ColorTheme(){};
    private final String testSuiteName;

    public Configuration(String string, Logger[] loggerArray, Options options) {
        this.options = options;
        this.testSuiteName = string;
        this.logger = new TestLogger(loggerArray, this);
    }

    public ColorTheme getColorTheme() {
        return this.colorTheme;
    }

    public TestLogger getLogger() {
        return this.logger;
    }

    public Options getOptions() {
        return this.options;
    }

    public String getTestSuiteName() {
        return this.testSuiteName;
    }

    public JupiterTestListener getTestListener() {
        switch (this.options.getDisplayMode()) {
            case "tree": {
                return new TreePrintingTestListener(this);
            }
        }
        return new FlatPrintingTestListener(this);
    }

    public Optional<TestExecutionListener> createRunListener(ClassLoader classLoader) {
        return this.options.getRunListener().map(string -> {
            try {
                Object obj = classLoader.loadClass((String)string).newInstance();
                return (TestExecutionListener)obj;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        });
    }

    public String decodeName(String string) {
        if (!this.options.isDecodeScalaNames()) {
            return string;
        }
        try {
            Class<?> clazz = Class.forName("scala.reflect.NameTransformer");
            Method method = clazz.getMethod("decode", String.class);
            String string2 = (String)method.invoke(null, string);
            return string2 == null ? string : string2;
        }
        catch (Throwable throwable) {
            return string;
        }
    }

    public String formatIdentifier(TestPlan testPlan, TestIdentifier testIdentifier) {
        return new TestIdentifierFormatter(testPlan, testIdentifier).format();
    }

    public String extractClassNameOrDisplayName(TestIdentifier testIdentifier) {
        return testIdentifier.getSource().map(testSource -> this.extractClassName(testIdentifier)).orElse(testIdentifier.getDisplayName());
    }

    public String extractClassName(TestIdentifier testIdentifier) {
        TestSource testSource = (TestSource)testIdentifier.getSource().orElseThrow(() -> new RuntimeException("Test identifier without source: " + testIdentifier));
        if (testSource instanceof ClassSource) {
            return ((ClassSource)testSource).getClassName();
        }
        if (testSource instanceof MethodSource) {
            return ((MethodSource)testSource).getClassName();
        }
        throw new RuntimeException("Test identifier with unknown source: " + testIdentifier);
    }

    public Optional<String> extractMethodName(TestIdentifier testIdentifier) {
        TestSource testSource = testIdentifier.getSource().orElse(null);
        if (testSource instanceof MethodSource) {
            MethodSource methodSource = (MethodSource)testSource;
            return Optional.of(methodSource.getMethodName());
        }
        return Optional.empty();
    }

    public String buildInfoMessage(Throwable throwable) {
        return this.buildColoredMessage(throwable, this.colorTheme.normalName2());
    }

    public String buildInfoName(TestIdentifier testIdentifier) {
        return this.buildColoredName(testIdentifier, this.colorTheme.normalName1(), this.colorTheme.normalName2(), this.colorTheme.normalName3());
    }

    public String buildErrorMessage(Throwable throwable) {
        return this.buildColoredMessage(throwable, this.colorTheme.errorName2());
    }

    public String buildErrorName(TestIdentifier testIdentifier) {
        return this.buildColoredName(testIdentifier, this.colorTheme.errorName1(), this.colorTheme.errorName2(), this.colorTheme.errorName3());
    }

    private String buildColoredName(TestIdentifier testIdentifier, Color color, Color color2, Color color3) {
        String string2 = this.extractClassNameOrDisplayName(testIdentifier);
        Optional<String> optional = this.extractMethodName(testIdentifier);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.buildColoredClassName(this.decodeName(string2), color));
        optional.ifPresent(string -> stringBuilder.append(this.buildColoredMethodName((String)string, color2, color3)));
        return stringBuilder.toString();
    }

    private String buildColoredMessage(Throwable throwable, Color color) {
        if (throwable == null) {
            return "null";
        }
        if (!this.options.isExceptionClassLogEnabled()) {
            return throwable.getMessage();
        }
        if (!this.options.isAssertLogEnabled() && throwable instanceof AssertionError) {
            return throwable.getMessage();
        }
        String string = this.decodeName(throwable.getClass().getName());
        return this.buildColoredClassName(string, color) + ": " + throwable.getMessage();
    }

    private String buildColoredClassName(String string, Color color) {
        int n;
        int n2 = string.indexOf(36);
        int n3 = n = n2 == -1 ? string.lastIndexOf(46) : string.lastIndexOf(46, n2);
        if (n == -1) {
            return color.format(string);
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        return string2 + '.' + color.format(string3);
    }

    private String buildColoredMethodName(String string, Color color, Color color2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('.');
        int n = string.lastIndexOf(91);
        int n2 = string.lastIndexOf(93);
        if (n == -1 || n2 < n) {
            stringBuilder.append(color.format(this.decodeName(string)));
        } else {
            stringBuilder.append(color.format(this.decodeName(string.substring(0, n))));
            stringBuilder.append('[');
            stringBuilder.append(color2.format(string.substring(n + 1, n2)));
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    class TestIdentifierFormatter {
        static final String VINTAGE_ENGINE = "junit-vintage";
        final TestPlan testPlan;
        final TestIdentifier identifier;
        private String testEngine;

        TestIdentifierFormatter(TestPlan testPlan, TestIdentifier testIdentifier) {
            this.testPlan = testPlan;
            this.identifier = testIdentifier;
        }

        public String format() {
            List<TestIdentifier> list = this.getPath(this.testPlan, this.identifier);
            this.testEngine = UniqueId.parse((String)this.identifier.getUniqueId()).getEngineId().orElse(null);
            return list.stream().skip(1L).map(this::toName).filter(Objects::nonNull).collect(Collectors.joining());
        }

        private List<TestIdentifier> getPath(TestPlan testPlan, TestIdentifier testIdentifier) {
            ArrayList<TestIdentifier> arrayList = new ArrayList<TestIdentifier>();
            do {
                arrayList.add(testIdentifier);
            } while (null != (testIdentifier = (TestIdentifier)testPlan.getParent(testIdentifier).orElse(null)));
            Collections.reverse(arrayList);
            return arrayList;
        }

        private String toName(TestIdentifier testIdentifier) {
            String string = testIdentifier.getDisplayName();
            List list = UniqueId.parse((String)testIdentifier.getUniqueId()).getSegments();
            if (!list.isEmpty()) {
                UniqueId.Segment segment = (UniqueId.Segment)list.get(list.size() - 1);
                string = VINTAGE_ENGINE.equals(this.testEngine) ? this.toVintageName(testIdentifier, segment) : this.toName(segment);
            }
            return string;
        }

        private String toName(UniqueId.Segment segment) {
            String string;
            switch (segment.getType()) {
                case "class": {
                    string = this.colorClassName(segment.getValue(), Configuration.this.colorTheme.container());
                    break;
                }
                case "nested-class": {
                    string = Configuration.this.colorTheme.container().format("$" + segment.getValue());
                    break;
                }
                case "method": {
                    string = Configuration.this.colorTheme.testMethod().format("#" + segment.getValue());
                    break;
                }
                case "test-factory": {
                    string = Configuration.this.colorTheme.testFactory().format("#" + segment.getValue());
                    break;
                }
                case "dynamic-test": {
                    string = Configuration.this.colorTheme.dynamicTest().format(":" + segment.getValue());
                    break;
                }
                case "test-template": {
                    string = Configuration.this.colorTheme.testTemplate().format("#" + segment.getValue());
                    break;
                }
                case "test-template-invocation": {
                    string = Configuration.this.colorTheme.container().format(":" + segment.getValue());
                    break;
                }
                default: {
                    string = segment.getValue();
                }
            }
            if (Configuration.this.options.isTypesEnabled()) {
                string = segment.getType() + ":" + string;
            }
            return string;
        }

        private String toVintageName(TestIdentifier testIdentifier, UniqueId.Segment segment) {
            String string = segment.getType();
            if ("runner".equals(string)) {
                String string2 = testIdentifier.getLegacyReportingName();
                return this.colorClassName(string2, Configuration.this.colorTheme.container());
            }
            if ("test".equals(string)) {
                TestSource testSource = testIdentifier.getSource().orElse(null);
                if (null == testSource) {
                    return null;
                }
                if (testSource instanceof ClassSource) {
                    String string3 = "$" + testIdentifier.getDisplayName().replaceFirst(".*?\\$", "");
                    return Configuration.this.colorTheme.container().format(string3);
                }
                if (testSource instanceof MethodSource) {
                    String string4 = "#" + testIdentifier.getDisplayName();
                    return Configuration.this.colorTheme.testMethod().format(string4);
                }
            }
            return "/" + testIdentifier.getDisplayName();
        }

        private String colorClassName(String string, Color color) {
            String[] stringArray = string.split("\\.");
            return IntStream.range(0, stringArray.length).mapToObj(n -> {
                if (n == stringArray.length - 1) {
                    return color.format(stringArray[n]);
                }
                return stringArray[n];
            }).collect(Collectors.joining("."));
        }
    }
}

