/*
 * Decompiled with CFR 0.152.
 */
package net.aichler.jupiter.internal.event;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Objects;
import sbt.testing.Event;
import sbt.testing.EventHandler;

public class LoggingEventHandler
implements EventHandler {
    private final File targetFile;
    private final EventHandler eventHandler;

    public LoggingEventHandler(String string, EventHandler eventHandler) {
        this.targetFile = new File(string);
        this.eventHandler = Objects.requireNonNull(eventHandler, "eventHandler");
    }

    public void handle(Event event) {
        this.writeEventToFile(event);
        this.eventHandler.handle(event);
    }

    private void writeEventToFile(Event event) {
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.targetFile, true);
             BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));){
            bufferedWriter.write(event.toString());
            bufferedWriter.newLine();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

