/*
 * Decompiled with CFR 0.152.
 */
package net.aichler.jupiter.internal.listeners;

import net.aichler.jupiter.internal.Color;
import net.aichler.jupiter.internal.ColorTheme;
import net.aichler.jupiter.internal.Configuration;
import net.aichler.jupiter.internal.TestLogger;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.junit.platform.launcher.listeners.TestExecutionSummary;

public class SummaryPrintingTestListener
extends SummaryGeneratingListener {
    private final ColorTheme colorTheme;
    private final TestLogger logger;
    private final boolean isVerbose;

    public SummaryPrintingTestListener(Configuration configuration) {
        this.colorTheme = configuration.getColorTheme();
        this.isVerbose = configuration.getOptions().isVerbose();
        this.logger = configuration.getLogger();
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        TestExecutionSummary testExecutionSummary = this.getSummary();
        long l = System.currentTimeMillis() - testExecutionSummary.getTimeStarted();
        long l2 = testExecutionSummary.getTotalFailureCount();
        long l3 = testExecutionSummary.getTestsSkippedCount();
        long l4 = testExecutionSummary.getTestsFoundCount();
        Color color = l3 > 0L ? this.colorTheme.ignoreCount() : this.colorTheme.info();
        Color color2 = l2 > 0L ? this.colorTheme.errorCount() : this.colorTheme.info();
        this.debugOrInfo("" + this.colorTheme.info().format("Test run finished: ") + color2.format(l2 + " failed") + this.colorTheme.info().format(", ") + color.format(l3 + " ignored") + this.colorTheme.info().format(", ") + this.colorTheme.info().format(l4 + " total, ") + this.colorTheme.info().format((double)l / 1000.0 + "s"));
    }

    private void debugOrInfo(String string) {
        if (this.isVerbose) {
            this.logger.info(string, new Object[0]);
            return;
        }
        this.logger.debug(string, new Object[0]);
    }
}

