/*
 * Decompiled with CFR 0.152.
 */
package net.aichler.jupiter.internal.options;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.aichler.jupiter.internal.options.Options;

public class OptionsParser {
    private static final String OPT_TESTS = "--tests=";
    private static final String OPT_TRACE_DISPATCH_EVENTS = "--trace-dispatch-events";
    private static final String OPT_DISPLAY_MODE = "--display-mode=";
    private static final String OPT_RUN_LISTENER = "--run-listener=";
    private static final String OPT_INCLUDE_TAGS = "--include-tags=";
    private static final String OPT_EXCLUDE_TAGS = "--exclude-tags=";
    private static final char DQ = '\"';
    private static final char SQ = '\'';

    public Options parse(String[] stringArray) {
        Options.Builder builder = new Options.Builder();
        for (String string : stringArray) {
            if ("-q".equals(string)) {
                builder.withQuiet(true);
                continue;
            }
            if ("-v".equals(string)) {
                builder.withVerbose(true);
                continue;
            }
            if ("-n".equals(string)) {
                builder.withColorsEnabled(false);
                continue;
            }
            if ("-s".equals(string)) {
                builder.withDecodeScalaNames(true);
                continue;
            }
            if ("-a".equals(string)) {
                builder.withAssertLogEnabled(true);
                continue;
            }
            if ("-c".equals(string)) {
                builder.withExceptionClassLogEnabled(false);
                continue;
            }
            if ("--with-types".equals(string)) {
                builder.withTypesEnabled(true);
                continue;
            }
            if (string.startsWith(OPT_DISPLAY_MODE)) {
                builder.withDisplayMode(this.toValue(OPT_DISPLAY_MODE, string));
                continue;
            }
            if (string.startsWith(OPT_TESTS)) {
                builder.withTestFilters(this.toSet(OPT_TESTS, string));
                continue;
            }
            if (string.startsWith(OPT_TRACE_DISPATCH_EVENTS)) {
                builder.withTraceDispatchEvents(true);
                continue;
            }
            if (string.startsWith(OPT_RUN_LISTENER)) {
                builder.withRunListener(this.toValue(OPT_RUN_LISTENER, string));
                continue;
            }
            if (string.startsWith(OPT_INCLUDE_TAGS)) {
                builder.withIncludeTags(this.toSet(OPT_INCLUDE_TAGS, string));
                continue;
            }
            if (string.startsWith(OPT_EXCLUDE_TAGS)) {
                builder.withExcludeTags(this.toSet(OPT_EXCLUDE_TAGS, string));
                continue;
            }
            if (string.startsWith("-D") && string.contains("=")) {
                builder.withSystemProperty(this.toEntry(string));
                continue;
            }
            if (string.startsWith("-") || string.startsWith("+")) continue;
            builder.withGlobPattern(string);
        }
        for (String string : stringArray) {
            if ("+q".equals(string)) {
                builder.withQuiet(false);
                continue;
            }
            if ("+v".equals(string)) {
                builder.withVerbose(false);
                continue;
            }
            if ("+n".equals(string)) {
                builder.withColorsEnabled(true);
                continue;
            }
            if ("+s".equals(string)) {
                builder.withDecodeScalaNames(false);
                continue;
            }
            if ("+a".equals(string)) {
                builder.withAssertLogEnabled(false);
                continue;
            }
            if (!"+c".equals(string)) continue;
            builder.withExceptionClassLogEnabled(true);
        }
        return builder.build();
    }

    private Map.Entry<String, String> toEntry(String string) {
        int n = string.indexOf(61);
        String string2 = string.substring(2, n);
        String string3 = string.substring(n + 1);
        return new AbstractMap.SimpleEntry<String, String>(string2, string3);
    }

    private Set<String> toSet(String string2, String string3) {
        String string4 = string3.substring(string2.length());
        String[] stringArray = this.stripQuotes(string4).split(",");
        return Arrays.stream(stringArray).map(String::trim).filter(string -> !string.isEmpty()).map(this::stripQuotes).collect(Collectors.toSet());
    }

    private String toValue(String string, String string2) {
        return string2.substring(string.length());
    }

    private String stripQuotes(String string) {
        int n = string.length();
        if (n > 1) {
            if ('\"' == string.charAt(0) && '\"' == string.charAt(n - 1)) {
                return string.substring(1, n - 1);
            }
            if ('\'' == string.charAt(0) && '\'' == string.charAt(n - 1)) {
                return string.substring(1, n - 1);
            }
        }
        return string;
    }
}

