/*
 * Decompiled with CFR 0.152.
 */
package net.aichler.jupiter.api;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import net.aichler.jupiter.api.JupiterTestFingerprint;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import sbt.testing.Fingerprint;
import sbt.testing.Selector;
import sbt.testing.SuiteSelector;

public class JupiterTestCollector {
    private final ClassLoader classLoader;
    private final URL[] runtimeClassPath;
    private final File classDirectory;

    public Result collectTests() throws Exception {
        if (!this.classDirectory.exists()) {
            return Result.emptyResult();
        }
        URLClassLoader uRLClassLoader = new URLClassLoader(this.runtimeClassPath, this.classLoader);
        return this.invokeWithCustomClassLoader(uRLClassLoader, this::collectTests0);
    }

    private JupiterTestCollector(Builder builder) {
        this.runtimeClassPath = builder.runtimeClassPath;
        this.classDirectory = builder.classDirectory;
        this.classLoader = builder.classLoader;
    }

    private Result collectTests0() {
        HashSet<Path> hashSet = new HashSet<Path>();
        hashSet.add(Paths.get(this.classDirectory.getAbsolutePath(), new String[0]));
        LauncherDiscoveryRequest launcherDiscoveryRequest = LauncherDiscoveryRequestBuilder.request().selectors(DiscoverySelectors.selectClasspathRoots(hashSet)).selectors(new DiscoverySelector[]{DiscoverySelectors.selectDirectory((File)this.classDirectory)}).build();
        TestPlan testPlan = LauncherFactory.create().discover(launcherDiscoveryRequest);
        Result result = new Result();
        for (TestIdentifier testIdentifier : testPlan.getRoots()) {
            for (TestIdentifier testIdentifier2 : testPlan.getChildren(testIdentifier)) {
                String string = this.fullyQualifiedName(testIdentifier2);
                SuiteSelector suiteSelector = new SuiteSelector();
                Item item = new Item();
                item.fullyQualifiedClassName = string;
                item.selectors.add(suiteSelector);
                item.explicit = false;
                result.discoveredTests.add(item);
            }
        }
        return result;
    }

    private String fullyQualifiedName(TestIdentifier testIdentifier) {
        TestSource testSource = testIdentifier.getSource().orElse(null);
        if (testSource instanceof ClassSource) {
            ClassSource classSource = (ClassSource)testSource;
            return classSource.getClassName();
        }
        if (testSource instanceof MethodSource) {
            MethodSource methodSource = (MethodSource)testSource;
            return methodSource.getClassName() + '#' + methodSource.getMethodName() + '(' + methodSource.getMethodParameterTypes() + ')';
        }
        return testIdentifier.getLegacyReportingName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T invokeWithCustomClassLoader(ClassLoader classLoader, Callable<T> callable) throws Exception {
        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            T t = callable.call();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader2);
        }
    }

    public static class Builder {
        private ClassLoader classLoader;
        private URL[] runtimeClassPath = new URL[0];
        private File classDirectory;

        public Builder withClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public Builder withRuntimeClassPath(URL[] uRLArray) {
            this.runtimeClassPath = uRLArray;
            return this;
        }

        public Builder withClassDirectory(File file) {
            this.classDirectory = file;
            return this;
        }

        public JupiterTestCollector build() {
            return new JupiterTestCollector(this);
        }
    }

    public static class Item {
        private String fullyQualifiedClassName;
        private Fingerprint fingerprint = new JupiterTestFingerprint();
        private List<Selector> selectors = new ArrayList<Selector>();
        private boolean explicit;

        public String getFullyQualifiedClassName() {
            return this.fullyQualifiedClassName;
        }

        public Fingerprint getFingerprint() {
            return this.fingerprint;
        }

        public boolean isExplicit() {
            return this.explicit;
        }

        public Selector[] getSelectors() {
            return this.selectors.toArray(new Selector[0]);
        }

        public String toString() {
            return "Item(" + this.fullyQualifiedClassName + ", " + this.fingerprint + ", " + this.selectors + ", " + this.explicit + ')';
        }
    }

    public static class Result {
        static final Result EMPTY_RESULT = new Result();
        private List<Item> discoveredTests = new ArrayList<Item>();

        public static Result emptyResult() {
            return EMPTY_RESULT;
        }

        public List<Item> getDiscoveredTests() {
            return this.discoveredTests;
        }
    }
}

