/*
 * Decompiled with CFR 0.152.
 */
package scala_maven;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import scala_maven.ScalaMojoSupport;
import scala_maven.VersionNumber;
import scala_maven_executions.JavaMainCaller;
import scala_maven_executions.MainHelper;

public class ScalaConsoleMojo
extends ScalaMojoSupport {
    private static final String JLINE = "jline";
    private static final String SCALA_ORG_GROUP = "org.scala-lang";
    protected String mainConsole;
    protected boolean useTestClasspath;
    protected boolean useRuntimeClasspath;
    protected File javaRebelPath;

    @Override
    protected void doExecute() throws Exception {
        JavaMainCaller jcmd = super.getScalaCommand(false, this.mainConsole);
        VersionNumber scalaVersion = super.findScalaVersion();
        Set<String> classpath = this.setupClassPathForConsole(scalaVersion);
        if (this.fork) {
            super.getLog().info((CharSequence)"Ignoring fork for console execution.");
        }
        String classpathStr = MainHelper.toMultiPath(classpath.toArray(new String[classpath.size()]));
        jcmd.addArgs(this.args);
        jcmd.addOption("-cp", classpathStr);
        super.addCompilerPluginOptions(jcmd);
        this.handleJavaRebel(jcmd);
        jcmd.run(this.displayCmd);
    }

    private void handleJavaRebel(JavaMainCaller jcmd) throws IOException {
        if (this.javaRebelPath != null) {
            String canonicalJavaRebelPath = this.javaRebelPath.getCanonicalPath();
            if (this.javaRebelPath.exists()) {
                jcmd.addJvmArgs("-noverify", String.format("-javaagent:%s", canonicalJavaRebelPath));
            } else {
                super.getLog().warn((CharSequence)String.format("javaRevelPath '%s' not found", canonicalJavaRebelPath));
            }
        }
    }

    private Set<String> setupClassPathForConsole(VersionNumber scalaVersion) throws Exception {
        HashSet<String> classpath = new HashSet<String>();
        classpath.addAll(this.setupProjectClasspaths());
        classpath.addAll(this.setupConsoleClasspaths(scalaVersion));
        return classpath;
    }

    private Set<String> setupProjectClasspaths() throws Exception {
        HashSet<String> classpath = new HashSet<String>();
        super.addCompilerToClasspath(classpath);
        super.addLibraryToClasspath(classpath);
        if (this.useTestClasspath) {
            classpath.addAll(this.project.getTestClasspathElements());
        }
        if (this.useRuntimeClasspath) {
            classpath.addAll(this.project.getRuntimeClasspathElements());
        }
        return classpath;
    }

    private Set<String> setupConsoleClasspaths(VersionNumber scalaVersion) throws Exception {
        HashSet<String> classpath = new HashSet<String>();
        super.addToClasspath(this.resolveJLine(scalaVersion, this.fallbackJLine(scalaVersion)), classpath, true);
        return classpath;
    }

    private Artifact resolveJLine(VersionNumber scalaVersion, Artifact defaultFallback) throws Exception {
        Artifact compilerArtifact = super.scalaCompilerArtifact(scalaVersion.toString());
        Set<Artifact> compilerDeps = super.resolveArtifactDependencies(compilerArtifact);
        for (Artifact a : compilerDeps) {
            super.getLog().warn((CharSequence)a.toString());
            if (!this.filterForJline(a)) continue;
            return a;
        }
        super.getLog().warn((CharSequence)"Unable to determine the required Jline dependency from the POM. Falling back to hard-coded defaults.");
        super.getLog().warn((CharSequence)"If you get an InvocationTargetException, then this probably means we guessed the wrong version for JLine");
        super.getLog().warn((CharSequence)String.format("Guessed JLine: %s", defaultFallback.toString()));
        return defaultFallback;
    }

    private boolean filterForJline(Artifact artifact) {
        String artifactId = artifact.getArtifactId();
        String groupId = artifact.getGroupId();
        return artifactId.equals(JLINE) && (groupId.equals(JLINE) || groupId.equals(JLINE));
    }

    private Artifact fallbackJLine(VersionNumber scalaVersion) {
        VersionNumber scala2_12_0M4 = new VersionNumber("2.12.0-M4");
        VersionNumber scala2_11_0 = new VersionNumber("2.11.0");
        VersionNumber scala2_9_0 = new VersionNumber("2.9.0");
        if (scala2_12_0M4.compareTo(scalaVersion) <= 0) {
            return this.factory.createArtifact(JLINE, JLINE, "2.14.1", "", "jar");
        }
        if (scala2_11_0.compareTo(scalaVersion) <= 0) {
            return this.factory.createArtifact(JLINE, JLINE, "2.12", "", "jar");
        }
        if (scala2_9_0.compareTo(scalaVersion) <= 0) {
            return this.factory.createArtifact(SCALA_ORG_GROUP, JLINE, scalaVersion.toString(), "", "jar");
        }
        return this.factory.createArtifact(JLINE, JLINE, "0.9.94", "", "jar");
    }
}

