/*
 * Decompiled with CFR 0.152.
 */
package sbt_inc;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.exec.LogOutputStream;
import org.apache.maven.plugin.logging.Log;
import sbt.internal.inc.AnalyzingCompiler;
import sbt.internal.inc.FileAnalysisStore;
import sbt.internal.inc.Locate;
import sbt.internal.inc.LoggedReporter;
import sbt.internal.inc.ScalaInstance;
import sbt.internal.inc.ZincUtil;
import sbt.util.Logger;
import sbt_inc.CompilerBridgeFactory;
import sbt_inc.ForkedSbtIncrementalCompilerMain;
import sbt_inc.InProcessSbtIncrementalCompiler;
import sbt_inc.MavenLoggerSbtAdapter;
import sbt_inc.SbtIncrementalCompiler;
import sbt_inc.ScalaInstances;
import scala.Function1;
import scala.Option;
import scala.jdk.FunctionWrappers;
import scala_maven.MavenArtifactResolver;
import scala_maven.VersionNumber;
import scala_maven_executions.Fork;
import scala_maven_executions.ForkLogger;
import xsbti.PathBasedFile;
import xsbti.Reporter;
import xsbti.T2;
import xsbti.VirtualFile;
import xsbti.compile.AnalysisContents;
import xsbti.compile.AnalysisStore;
import xsbti.compile.ClasspathOptions;
import xsbti.compile.ClasspathOptionsUtil;
import xsbti.compile.CompileAnalysis;
import xsbti.compile.CompileOrder;
import xsbti.compile.CompilerCache;
import xsbti.compile.Compilers;
import xsbti.compile.DefinesClass;
import xsbti.compile.GlobalsCache;
import xsbti.compile.IncOptions;
import xsbti.compile.IncrementalCompiler;
import xsbti.compile.PerClasspathEntryLookup;
import xsbti.compile.ScalaCompiler;
import xsbti.compile.Setup;
import xsbti.compile.ZincCompilerUtil;

public final class SbtIncrementalCompilers {
    public static SbtIncrementalCompiler make(File javaHome, MavenArtifactResolver resolver, File secondaryCacheDir, Log mavenLogger, File cacheFile, CompileOrder compileOrder, VersionNumber scalaVersion, Collection<File> compilerAndDependencies, Collection<File> libraryAndDependencies, String[] jvmArgs, File javaExec, List<File> forkBootClasspath) throws Exception {
        ScalaInstance scalaInstance = ScalaInstances.makeScalaInstance(scalaVersion.toString(), compilerAndDependencies, libraryAndDependencies);
        File compilerBridgeJar = CompilerBridgeFactory.getCompiledBridgeJar(scalaVersion, scalaInstance, secondaryCacheDir, resolver, mavenLogger);
        if (jvmArgs == null || jvmArgs.length == 0) {
            return SbtIncrementalCompilers.makeInProcess(javaHome, cacheFile, compileOrder, scalaInstance, compilerBridgeJar, new MavenLoggerSbtAdapter(mavenLogger));
        }
        return SbtIncrementalCompilers.makeForkedProcess(javaHome, cacheFile, compileOrder, compilerBridgeJar, scalaVersion, compilerAndDependencies, libraryAndDependencies, mavenLogger, jvmArgs, javaExec, forkBootClasspath);
    }

    static SbtIncrementalCompiler makeInProcess(File javaHome, File cacheFile, CompileOrder compileOrder, ScalaInstance scalaInstance, File compilerBridgeJar, Logger sbtLogger) {
        Compilers compilers = SbtIncrementalCompilers.makeCompilers(scalaInstance, javaHome, compilerBridgeJar);
        AnalysisStore analysisStore = AnalysisStore.getCachedStore((AnalysisStore)FileAnalysisStore.binary((File)cacheFile));
        Setup setup = SbtIncrementalCompilers.makeSetup(cacheFile, (xsbti.Logger)sbtLogger);
        IncrementalCompiler compiler = ZincUtil.defaultIncrementalCompiler();
        return new InProcessSbtIncrementalCompiler(compilers, analysisStore, setup, compiler, compileOrder, (xsbti.Logger)sbtLogger);
    }

    private static SbtIncrementalCompiler makeForkedProcess(File javaHome, File cacheFile, CompileOrder compileOrder, File compilerBridgeJar, VersionNumber scalaVersion, Collection<File> compilerAndDependencies, Collection<File> libraryAndDependencies, final Log mavenLogger, String[] jvmArgs, File javaExec, List<File> pluginArtifacts) {
        List forkClasspath = pluginArtifacts.stream().map(File::getPath).collect(Collectors.toList());
        return (classpathElements, sources, classesDirectory, scalacOptions, javacOptions) -> {
            try {
                String[] args = new ForkedSbtIncrementalCompilerMain.Args(javaHome, cacheFile, compileOrder, compilerBridgeJar, scalaVersion.toString(), compilerAndDependencies, libraryAndDependencies, classpathElements, sources, classesDirectory, scalacOptions, javacOptions, mavenLogger.isDebugEnabled()).generateArgs();
                Fork fork = new Fork(ForkedSbtIncrementalCompilerMain.class.getName(), forkClasspath, jvmArgs, args, javaExec);
                fork.run((OutputStream)new LogOutputStream(){
                    private final ForkLogger forkLogger;
                    {
                        this.forkLogger = new ForkLogger(this){
                            final /* synthetic */ 1 this$0;
                            {
                                this.this$0 = this$0;
                            }

                            @Override
                            public void onException(Exception t) {
                                mavenLogger.error((Throwable)t);
                            }

                            @Override
                            public void onError(String content) {
                                mavenLogger.error((CharSequence)content);
                            }

                            @Override
                            public void onWarn(String content) {
                                mavenLogger.warn((CharSequence)content);
                            }

                            @Override
                            public void onInfo(String content) {
                                mavenLogger.info((CharSequence)content);
                            }

                            @Override
                            public void onDebug(String content) {
                                mavenLogger.debug((CharSequence)content);
                            }
                        };
                    }

                    protected void processLine(String line, int level) {
                        this.forkLogger.processLine(line);
                    }

                    public void close() throws IOException {
                        this.forkLogger.forceNextLineToFlush();
                        super.close();
                    }
                });
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    private static Compilers makeCompilers(ScalaInstance scalaInstance, File javaHome, File compilerBridgeJar) {
        AnalyzingCompiler scalaCompiler = new AnalyzingCompiler((xsbti.compile.ScalaInstance)scalaInstance, ZincCompilerUtil.constantBridgeProvider((xsbti.compile.ScalaInstance)scalaInstance, (File)compilerBridgeJar), ClasspathOptionsUtil.auto(), (Function1)new FunctionWrappers.FromJavaConsumer(noop -> {}), Option.apply(null));
        return ZincUtil.compilers((xsbti.compile.ScalaInstance)scalaInstance, (ClasspathOptions)ClasspathOptionsUtil.boot(), (Option)Option.apply((Object)javaHome.toPath()), (ScalaCompiler)scalaCompiler);
    }

    private static Setup makeSetup(File cacheFile, xsbti.Logger sbtLogger) {
        PerClasspathEntryLookup lookup = new PerClasspathEntryLookup(){

            public Optional<CompileAnalysis> analysis(VirtualFile classpathEntry) {
                File analysisStoreFile;
                Path path = ((PathBasedFile)classpathEntry).toPath();
                String analysisStoreFileName = null;
                if (Files.isDirectory(path, new LinkOption[0])) {
                    if (path.getFileName().toString().equals("classes")) {
                        analysisStoreFileName = "compile";
                    } else if (path.getFileName().toString().equals("test-classes")) {
                        analysisStoreFileName = "test-compile";
                    }
                }
                if (analysisStoreFileName != null && (analysisStoreFile = path.getParent().resolve("analysis").resolve(analysisStoreFileName).toFile()).exists()) {
                    return AnalysisStore.getCachedStore((AnalysisStore)FileAnalysisStore.binary((File)analysisStoreFile)).get().map(AnalysisContents::getAnalysis);
                }
                return Optional.empty();
            }

            public DefinesClass definesClass(VirtualFile classpathEntry) {
                return classpathEntry.name().equals("rt.jar") ? className -> false : Locate.definesClass((VirtualFile)classpathEntry);
            }
        };
        return Setup.of((PerClasspathEntryLookup)lookup, (boolean)false, (File)cacheFile, (GlobalsCache)CompilerCache.fresh(), (IncOptions)IncOptions.of(), (Reporter)new LoggedReporter(100, sbtLogger, pos -> pos), Optional.empty(), (T2[])new T2[0]);
    }
}

