/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.abstraction;

import java.util.function.Supplier;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import net.andreinc.mockneat.abstraction.MockUnit;
import net.andreinc.mockneat.utils.ValidationUtils;

public interface MockUnitFloat
extends MockUnit<Float> {
    default public MockUnit<DoubleStream> doubleStream() {
        Supplier<DoubleStream> supp = () -> DoubleStream.generate(((Supplier)this.supplier())::get);
        return () -> supp;
    }

    default public MockUnit<float[]> arrayPrimitive(int size) {
        ValidationUtils.isTrue(size >= 0, "The size needs to be bigger than 0 (>=).", new Object[0]);
        Supplier<float[]> supp = () -> {
            float[] result = new float[size];
            IntStream.range(0, size).forEach(i -> {
                result[i] = ((Float)this.val()).floatValue();
            });
            return result;
        };
        return () -> supp;
    }

    default public MockUnit<Float[]> array(int size) {
        ValidationUtils.isTrue(size >= 0, "The size needs to be bigger than 0 (>=).", new Object[0]);
        Supplier<Float[]> supp = () -> {
            Float[] result = new Float[size];
            IntStream.range(0, size).forEach(i -> {
                result[i] = (Float)this.val();
            });
            return result;
        };
        return () -> supp;
    }
}

