/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.financial;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.abstraction.MockUnitBase;
import net.andreinc.mockneat.abstraction.MockUnitString;
import net.andreinc.mockneat.types.enums.CreditCardType;
import net.andreinc.mockneat.types.enums.DictType;
import net.andreinc.mockneat.utils.ValidationUtils;

public class CreditCards
extends MockUnitBase
implements MockUnitString {
    public static CreditCards creditCards() {
        return MockNeat.threadLocal().creditCards();
    }

    protected CreditCards() {
    }

    public CreditCards(MockNeat mockNeat) {
        super(mockNeat);
    }

    @Override
    public Supplier<String> supplier() {
        return this.type(CreditCardType.AMERICAN_EXPRESS).supplier();
    }

    public MockUnitString names() {
        return this.mockNeat.dicts().type(DictType.CREDIT_CARD_NAMES);
    }

    public MockUnitString type(CreditCardType type) {
        ValidationUtils.notNull(type, "type");
        Supplier<String> supplier = () -> this.generateCreditCard(type);
        return () -> supplier;
    }

    public MockUnitString custom(int length, Integer ... prefix) {
        ValidationUtils.notEmpty(prefix, "prefix");
        ValidationUtils.isTrue(length >= 12 && length < 20, "Credit Card number length should be a value in the interval [12, 20).", new Object[0]);
        Supplier<String> supplier = () -> this.generateCreditCard(length, prefix);
        return () -> supplier;
    }

    public MockUnitString types(CreditCardType ... types) {
        ValidationUtils.notEmptyOrNullValues(types, "types");
        Supplier<String> supplier = () -> {
            CreditCardType creditCardType = this.mockNeat.from(types).val();
            return (String)this.type(creditCardType).val();
        };
        return () -> supplier;
    }

    public MockUnitString amex() {
        return this.type(CreditCardType.AMERICAN_EXPRESS);
    }

    public MockUnitString visa() {
        return this.type(CreditCardType.VISA_16);
    }

    public MockUnitString masterCard() {
        return this.type(CreditCardType.MASTERCARD);
    }

    private String generateCreditCard(int length, List<List<Integer>> prefixes) {
        int cnt = length - 1;
        int[] results = new int[length];
        List<Integer> prefix = this.mockNeat.from(prefixes).val();
        for (int i = 0; i < cnt; ++i) {
            results[i] = i < prefix.size() ? prefix.get(i) : (Integer)this.mockNeat.ints().range(0, 10).val();
        }
        boolean dblFlag = true;
        int sum = 0;
        while (cnt-- > 0) {
            int dbl;
            sum = dblFlag ? (sum += (dbl = 2 * results[cnt]) > 9 ? dbl % 10 + 1 : dbl) : (sum += results[cnt]);
            dblFlag = !dblFlag;
        }
        results[length - 1] = 9 * sum % 10;
        StringBuilder buff = new StringBuilder();
        Arrays.stream(results).forEach(buff::append);
        return buff.toString();
    }

    private List<Integer> fromNumber(int num) {
        LinkedList<Integer> list = new LinkedList<Integer>();
        for (int tmp = num; tmp != 0; tmp /= 10) {
            list.add(0, tmp % 10);
        }
        return Collections.unmodifiableList(list);
    }

    private String generateCreditCard(int length, Integer ... prefixes) {
        return this.generateCreditCard(length, Arrays.stream(prefixes).map(this::fromNumber).collect(Collectors.toList()));
    }

    private String generateCreditCard(CreditCardType creditCardType) {
        return this.generateCreditCard((int)creditCardType.getLength(), creditCardType.getPrefixes());
    }
}

