/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.types;

import java.util.Random;
import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.abstraction.MockUnitBase;
import net.andreinc.mockneat.abstraction.MockUnitFloat;
import net.andreinc.mockneat.utils.ValidationUtils;

public class Floats
extends MockUnitBase
implements MockUnitFloat {
    private final Random random;

    public static Floats floats() {
        return MockNeat.threadLocal().floats();
    }

    protected Floats() {
        this(MockNeat.threadLocal());
    }

    public Floats(MockNeat mockNeat) {
        super(mockNeat);
        this.random = mockNeat.getRandom();
    }

    @Override
    public Supplier<Float> supplier() {
        return this.random::nextFloat;
    }

    public MockUnitFloat range(float lowerBound, float upperBound) {
        ValidationUtils.notNull(Float.valueOf(lowerBound), "lowerBound");
        ValidationUtils.notNull(Float.valueOf(upperBound), "upperBound");
        ValidationUtils.isTrue(lowerBound >= 0.0f, "The input parameter 'lowerBound' should be >= 0.0.", new Object[0]);
        ValidationUtils.isTrue(upperBound > 0.0f, "The input parameter 'upperBound' should be > 0.0.", new Object[0]);
        ValidationUtils.isTrue(upperBound > lowerBound, "The input parameter 'upperBound' > 'lowerBound'.", new Object[0]);
        Supplier<Float> supp = () -> Float.valueOf(this.random.nextFloat() * (upperBound - lowerBound) + lowerBound);
        return () -> supp;
    }

    public MockUnitFloat bound(float bound) {
        return this.range(0.0f, bound);
    }

    public MockUnitFloat from(float[] alphabet) {
        ValidationUtils.notEmpty(alphabet, "alphabet", new Object[0]);
        Supplier<Float> supp = () -> {
            int idx = this.random.nextInt(alphabet.length);
            return Float.valueOf(alphabet[idx]);
        };
        return () -> supp;
    }
}

