/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.types;

import java.util.Random;
import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.abstraction.MockUnitBase;
import net.andreinc.mockneat.abstraction.MockUnitInt;
import net.andreinc.mockneat.utils.ValidationUtils;

public class Ints
extends MockUnitBase
implements MockUnitInt {
    private final Random random;

    public static Ints ints() {
        return MockNeat.threadLocal().ints();
    }

    protected Ints() {
        this(MockNeat.threadLocal());
    }

    public Ints(MockNeat mockNeat) {
        super(mockNeat);
        this.random = mockNeat.getRandom();
    }

    @Override
    public Supplier<Integer> supplier() {
        return this.random::nextInt;
    }

    public MockUnitInt bound(Integer bound) {
        ValidationUtils.isTrue(bound >= 0, "The input parameter 'lowerBound' should be >= 0.0.", new Object[0]);
        Supplier<Integer> supp = () -> this.random.nextInt(bound);
        return () -> supp;
    }

    public MockUnitInt upperBound(int upperBound) {
        return this.bound(upperBound);
    }

    public MockUnitInt lowerBound(int lowerBound) {
        ValidationUtils.isTrue(lowerBound != Integer.MAX_VALUE, "The 'lowerB    ound' should be different than Integer.MAX_VALUE.", new Object[0]);
        ValidationUtils.isTrue(lowerBound >= 0, "The input parameter 'lowerBound' should be >= 0.0.", new Object[0]);
        return this.rangeClosed(lowerBound, Integer.MAX_VALUE);
    }

    public MockUnitInt range(Integer lowerBound, Integer upperBound) {
        ValidationUtils.notNull(lowerBound, "lowerBound");
        ValidationUtils.notNull(upperBound, "upperBound");
        ValidationUtils.isTrue(lowerBound >= 0, "The input parameter 'lowerBound' should be >= 0.0.", new Object[0]);
        ValidationUtils.isTrue(upperBound > 0, "The input parameter 'upperBound' should be > 0.0.", new Object[0]);
        ValidationUtils.isTrue(upperBound > lowerBound, "The input parameter 'upperBound' > 'lowerBound'.", new Object[0]);
        Supplier<Integer> supp = () -> this.random.nextInt(upperBound - lowerBound) + lowerBound;
        return () -> supp;
    }

    public MockUnitInt rangeClosed(int lowerBound, int upperBound) {
        ValidationUtils.notNull(lowerBound, "lowerBound");
        ValidationUtils.notNull(upperBound, "upperBound");
        ValidationUtils.isTrue(lowerBound >= 0, "The input parameter 'lowerBound' should be >= 0.0.", new Object[0]);
        ValidationUtils.isTrue(upperBound > 0, "The input parameter 'upperBound' should be > 0.0.", new Object[0]);
        ValidationUtils.isTrue(upperBound > lowerBound, "The input parameter 'upperBound' > 'lowerBound'.", new Object[0]);
        Supplier<Integer> supp = () -> this.random.nextInt(upperBound - lowerBound + 1) + lowerBound;
        return () -> supp;
    }

    public MockUnitInt from(int[] alphabet) {
        ValidationUtils.notEmpty(alphabet, "alphabet", new Object[0]);
        Supplier<Integer> supp = () -> {
            int idx = this.random.nextInt(alphabet.length);
            return alphabet[idx];
        };
        return () -> supp;
    }
}

