/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation;

import java.lang.reflect.Type;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.LoadedTypeInitializer;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatchers;

public class Forwarding
implements Implementation {
    private static final String FIELD_PREFIX = "forwarding";
    protected final String fieldName;
    protected final TypeDescription.Generic fieldType;
    protected final PreparationHandler preparationHandler;

    protected Forwarding(String fieldName, TypeDescription.Generic fieldType, PreparationHandler preparationHandler) {
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.preparationHandler = preparationHandler;
    }

    public static Implementation to(Object delegate) {
        return Forwarding.to(delegate, String.format("%s$%d", FIELD_PREFIX, Math.abs(delegate.hashCode() % Integer.MAX_VALUE)));
    }

    public static Implementation to(Object delegate, String fieldName) {
        return new Forwarding(fieldName, new TypeDescription.Generic.OfNonGenericType.ForLoadedType(delegate.getClass()), new PreparationHandler.ForStaticInstance(delegate));
    }

    public static Implementation toStaticField(String fieldName, Type fieldType) {
        return Forwarding.toStaticField(fieldName, TypeDefinition.Sort.describe(fieldType));
    }

    public static Implementation toStaticField(String fieldName, TypeDefinition fieldType) {
        return new Forwarding(fieldName, fieldType.asGenericType(), PreparationHandler.ForStaticField.INSTANCE);
    }

    public static Implementation toInstanceField(String fieldName, Type fieldType) {
        return Forwarding.toInstanceField(fieldName, TypeDefinition.Sort.describe(fieldType));
    }

    public static Implementation toInstanceField(String fieldName, TypeDefinition fieldType) {
        return new Forwarding(fieldName, fieldType.asGenericType(), PreparationHandler.ForInstanceField.INSTANCE);
    }

    @Override
    public ByteCodeAppender appender(Implementation.Target implementationTarget) {
        return new Appender(this.loadDelegate(implementationTarget.getInstrumentedType()));
    }

    private StackManipulation loadDelegate(TypeDescription instrumentedType) {
        return new StackManipulation.Compound(this.preparationHandler.loadFieldOwner(), FieldAccess.forField((FieldDescription.InDefinedShape)((FieldList)instrumentedType.getDeclaredFields().filter(ElementMatchers.named(this.fieldName))).getOnly()).getter());
    }

    @Override
    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        return this.preparationHandler.prepare(instrumentedType, this.fieldName, this.fieldType);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Forwarding that = (Forwarding)other;
        return this.fieldName.equals(that.fieldName) && this.fieldType.equals(that.fieldType) && this.preparationHandler.equals(that.preparationHandler);
    }

    public int hashCode() {
        int result = this.fieldName.hashCode();
        result = 31 * result + this.fieldType.hashCode();
        result = 31 * result + this.preparationHandler.hashCode();
        return result;
    }

    public String toString() {
        return "Forwarding{fieldName='" + this.fieldName + '\'' + ", fieldType=" + this.fieldType + ", preparationHandler=" + this.preparationHandler + '}';
    }

    protected class Appender
    implements ByteCodeAppender {
        private final StackManipulation delegateLoadingInstruction;

        private Appender(StackManipulation delegateLoadingInstruction) {
            this.delegateLoadingInstruction = delegateLoadingInstruction;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            if (!instrumentedMethod.isInvokableOn(Forwarding.this.fieldType.asErasure())) {
                throw new IllegalArgumentException("Cannot forward " + instrumentedMethod + " to " + Forwarding.this.fieldType);
            }
            if (instrumentedMethod.isStatic()) {
                throw new IllegalArgumentException("Cannot forward the static method " + instrumentedMethod);
            }
            StackManipulation.Size stackSize = new StackManipulation.Compound(this.delegateLoadingInstruction, MethodVariableAccess.allArgumentsOf(instrumentedMethod), MethodInvocation.invoke(instrumentedMethod).virtual(Forwarding.this.fieldType.asErasure()), MethodReturn.of(instrumentedMethod.getReturnType().asErasure())).apply(methodVisitor, implementationContext);
            return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.delegateLoadingInstruction.equals(((Appender)other).delegateLoadingInstruction) && Forwarding.this.equals(((Appender)other).getForwarding());
        }

        private Forwarding getForwarding() {
            return Forwarding.this;
        }

        public int hashCode() {
            return Forwarding.this.hashCode() + 31 * this.delegateLoadingInstruction.hashCode();
        }

        public String toString() {
            return "Forwarding.Appender{delegateLoadingInstruction=" + this.delegateLoadingInstruction + '}';
        }
    }

    protected static interface PreparationHandler {
        public InstrumentedType prepare(InstrumentedType var1, String var2, TypeDescription.Generic var3);

        public StackManipulation loadFieldOwner();

        public static class ForStaticInstance
        implements PreparationHandler {
            private final Object target;

            public ForStaticInstance(Object target) {
                this.target = target;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType, String fieldName, TypeDescription.Generic fieldType) {
                return instrumentedType.withField(new FieldDescription.Token(fieldName, 4105, fieldType)).withInitializer(new LoadedTypeInitializer.ForStaticField(fieldName, this.target));
            }

            @Override
            public StackManipulation loadFieldOwner() {
                return StackManipulation.Trivial.INSTANCE;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.target.equals(((ForStaticInstance)other).target);
            }

            public int hashCode() {
                return this.target.hashCode();
            }

            public String toString() {
                return "Forwarding.PreparationHandler.ForStaticInstance{target=" + this.target + '}';
            }
        }

        public static enum ForStaticField implements PreparationHandler
        {
            INSTANCE;


            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType, String fieldName, TypeDescription.Generic fieldType) {
                return instrumentedType.withField(new FieldDescription.Token(fieldName, 4105, fieldType));
            }

            @Override
            public StackManipulation loadFieldOwner() {
                return StackManipulation.Trivial.INSTANCE;
            }

            public String toString() {
                return "Forwarding.PreparationHandler.ForStaticField." + this.name();
            }
        }

        public static enum ForInstanceField implements PreparationHandler
        {
            INSTANCE;


            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType, String fieldName, TypeDescription.Generic fieldType) {
                if (instrumentedType.isInterface()) {
                    throw new IllegalStateException("Cannot define instance field '" + fieldName + "' for " + instrumentedType);
                }
                return instrumentedType.withField(new FieldDescription.Token(fieldName, 4097, fieldType));
            }

            @Override
            public StackManipulation loadFieldOwner() {
                return MethodVariableAccess.REFERENCE.loadOffset(0);
            }

            public String toString() {
                return "Forwarding.PreparationHandler.ForInstanceField." + this.name();
            }
        }
    }
}

