/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.utility;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CompoundList {
    private CompoundList() {
        throw new UnsupportedOperationException("Cannot create a compound list");
    }

    public static <S> List<S> of(S left, List<? extends S> right) {
        if (right.isEmpty()) {
            return Collections.singletonList(left);
        }
        ArrayList<S> list = new ArrayList<S>(1 + right.size());
        list.add(left);
        list.addAll(right);
        return list;
    }

    public static <S> List<S> of(List<? extends S> left, S right) {
        if (left.isEmpty()) {
            return Collections.singletonList(right);
        }
        ArrayList<S> list = new ArrayList<S>(left.size() + 1);
        list.addAll(left);
        list.add(right);
        return list;
    }

    public static <S> List<S> of(List<? extends S> left, List<? extends S> right) {
        ArrayList<S> list = new ArrayList<S>(left.size() + right.size());
        list.addAll(left);
        list.addAll(right);
        return list;
    }
}

