/*
 * Decompiled with CFR 0.152.
 */
package net.devh.boot.grpc.client.metrics;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import net.devh.boot.grpc.client.metrics.MetricsClientMeters;

public final class MetricsClientInstruments {
    private static final String CLIENT_ATTEMPT_STARTED = "grpc.client.attempt.started";
    private static final String CLIENT_ATTEMPT_SENT_COMPRESSED_MESSAGE_SIZE = "grpc.client.attempt.sent_total_compressed_message_size";
    private static final String CLIENT_ATTEMPT_RECEIVED_COMPRESSED_MESSAGE_SIZE = "grpc.client.attempt.rcvd_total_compressed_message_size";
    private static final String CLIENT_ATTEMPT_DURATION = "grpc.client.attempt.duration";
    private static final String CLIENT_CALL_DURATION = "grpc.client.call.duration";
    private static final double[] DEFAULT_SIZE_BUCKETS = new double[]{1024.0, 2048.0, 4096.0, 16384.0, 65536.0, 262144.0, 1048576.0, 4194304.0, 1.6777216E7, 6.7108864E7, 2.68435456E8, 1.073741824E9, 4.294967296E9};
    private static final Duration[] DEFAULT_LATENCY_BUCKETS = new Duration[]{Duration.ofNanos(10000L), Duration.ofNanos(50000L), Duration.ofNanos(100000L), Duration.ofNanos(300000L), Duration.ofNanos(600000L), Duration.ofNanos(800000L), Duration.ofMillis(1L), Duration.ofMillis(2L), Duration.ofMillis(3L), Duration.ofMillis(4L), Duration.ofMillis(5L), Duration.ofMillis(6L), Duration.ofMillis(8L), Duration.ofMillis(10L), Duration.ofMillis(13L), Duration.ofMillis(16L), Duration.ofMillis(20L), Duration.ofMillis(25L), Duration.ofMillis(30L), Duration.ofMillis(40L), Duration.ofMillis(50L), Duration.ofMillis(65L), Duration.ofMillis(80L), Duration.ofMillis(100L), Duration.ofMillis(130L), Duration.ofMillis(160L), Duration.ofMillis(200L), Duration.ofMillis(250L), Duration.ofMillis(300L), Duration.ofMillis(400L), Duration.ofMillis(500L), Duration.ofMillis(650L), Duration.ofMillis(800L), Duration.ofSeconds(1L), Duration.ofSeconds(2L), Duration.ofSeconds(5L), Duration.ofSeconds(10L), Duration.ofSeconds(20L), Duration.ofSeconds(50L), Duration.ofSeconds(100L)};

    private MetricsClientInstruments() {
    }

    static MetricsClientMeters newClientMetricsMeters(MeterRegistry registry) {
        MetricsClientMeters.Builder builder = MetricsClientMeters.newBuilder();
        builder.setAttemptCounter((Meter.MeterProvider<Counter>)Counter.builder((String)CLIENT_ATTEMPT_STARTED).description("The total number of RPC attempts started from the client side, including those that have not completed.").withRegistry(registry));
        builder.setSentMessageSizeDistribution((Meter.MeterProvider<DistributionSummary>)DistributionSummary.builder((String)CLIENT_ATTEMPT_SENT_COMPRESSED_MESSAGE_SIZE).description("Compressed message bytes sent per client call attempt").baseUnit("bytes").serviceLevelObjectives(DEFAULT_SIZE_BUCKETS).withRegistry(registry));
        builder.setReceivedMessageSizeDistribution((Meter.MeterProvider<DistributionSummary>)DistributionSummary.builder((String)CLIENT_ATTEMPT_RECEIVED_COMPRESSED_MESSAGE_SIZE).description("Compressed message bytes received per call attempt").baseUnit("bytes").serviceLevelObjectives(DEFAULT_SIZE_BUCKETS).withRegistry(registry));
        builder.setClientAttemptDuration((Meter.MeterProvider<Timer>)Timer.builder((String)CLIENT_ATTEMPT_DURATION).description("Time taken to complete a client call attempt").serviceLevelObjectives(DEFAULT_LATENCY_BUCKETS).withRegistry(registry));
        builder.setClientCallDuration((Meter.MeterProvider<Timer>)Timer.builder((String)CLIENT_CALL_DURATION).description("Time taken by gRPC to complete an RPC from application's perspective").serviceLevelObjectives(DEFAULT_LATENCY_BUCKETS).withRegistry(registry));
        return builder.build();
    }
}

