/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.xss.config;

import com.fasterxml.jackson.databind.JsonDeserializer;
import java.util.List;
import net.dreamlu.mica.xss.config.MicaXssProperties;
import net.dreamlu.mica.xss.core.DefaultXssCleaner;
import net.dreamlu.mica.xss.core.FormXssClean;
import net.dreamlu.mica.xss.core.JacksonXssClean;
import net.dreamlu.mica.xss.core.XssCleanInterceptor;
import net.dreamlu.mica.xss.core.XssCleaner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={MicaXssProperties.class})
@ConditionalOnProperty(prefix="mica.xss", name={"enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class MicaXssConfiguration
implements WebMvcConfigurer {
    private final MicaXssProperties xssProperties;

    @Bean
    @ConditionalOnMissingBean
    public XssCleaner xssCleaner(MicaXssProperties properties) {
        return new DefaultXssCleaner(properties);
    }

    @Bean
    public FormXssClean formXssClean(MicaXssProperties properties, XssCleaner xssCleaner) {
        return new FormXssClean(properties, xssCleaner);
    }

    @Bean
    public Jackson2ObjectMapperBuilderCustomizer xssJacksonCustomizer(MicaXssProperties properties, XssCleaner xssCleaner) {
        JacksonXssClean xssClean = new JacksonXssClean(properties, xssCleaner);
        return builder -> builder.deserializerByType(String.class, (JsonDeserializer)xssClean);
    }

    public void addInterceptors(InterceptorRegistry registry) {
        List<String> patterns = this.xssProperties.getPathPatterns();
        if (patterns.isEmpty()) {
            patterns.add("/**");
        }
        XssCleanInterceptor interceptor = new XssCleanInterceptor(this.xssProperties);
        registry.addInterceptor((HandlerInterceptor)interceptor).addPathPatterns(patterns).excludePathPatterns(this.xssProperties.getPathExcludePatterns()).order(Integer.MAX_VALUE);
    }

    public MicaXssConfiguration(MicaXssProperties xssProperties) {
        this.xssProperties = xssProperties;
    }
}

