/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.xss.core;

import net.dreamlu.mica.core.utils.Charsets;
import net.dreamlu.mica.core.utils.StringUtil;
import net.dreamlu.mica.xss.config.MicaXssProperties;
import net.dreamlu.mica.xss.core.XssCleaner;
import net.dreamlu.mica.xss.utils.XssUtil;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Entities;
import org.jsoup.safety.Cleaner;
import org.jsoup.safety.Safelist;
import org.springframework.web.util.HtmlUtils;

public class DefaultXssCleaner
implements XssCleaner {
    private final MicaXssProperties properties;

    @Override
    public String clean(String bodyHtml) {
        if (StringUtil.isBlank((CharSequence)bodyHtml)) {
            return bodyHtml;
        }
        MicaXssProperties.Mode mode = this.properties.getMode();
        if (MicaXssProperties.Mode.escape == mode) {
            return HtmlUtils.htmlEscape((String)bodyHtml, (String)Charsets.UTF_8_NAME);
        }
        Document.OutputSettings outputSettings = new Document.OutputSettings().escapeMode(Entities.EscapeMode.xhtml).prettyPrint(this.properties.isPrettyPrint());
        Document dirty = Jsoup.parseBodyFragment((String)bodyHtml, (String)"");
        Cleaner cleaner = new Cleaner((Safelist)XssUtil.WHITE_LIST);
        Document clean = cleaner.clean(dirty);
        clean.outputSettings(outputSettings);
        String escapedHtml = clean.body().html();
        if (this.properties.isEnableEscape()) {
            return escapedHtml;
        }
        return Entities.unescape((String)escapedHtml);
    }

    public DefaultXssCleaner(MicaXssProperties properties) {
        this.properties = properties;
    }
}

