/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import twitter4j.RetweetDetails;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterResponse;
import twitter4j.User;
import twitter4j.http.Response;
import twitter4j.org.json.JSONException;
import twitter4j.org.json.JSONObject;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Status
extends TwitterResponse
implements Serializable {
    private Date createdAt;
    private long id;
    private String text;
    private String source;
    private boolean isTruncated;
    private long inReplyToStatusId;
    private int inReplyToUserId;
    private boolean isFavorited;
    private String inReplyToScreenName;
    private double latitude = -1.0;
    private double longitude = -1.0;
    private RetweetDetails retweetDetails;
    private static final long serialVersionUID = 1608000492860584608L;
    private User user = null;

    Status(Response res, Twitter twitter) throws TwitterException {
        super(res);
        Element elem = res.asDocument().getDocumentElement();
        this.init(res, elem, twitter);
    }

    Status(Response res, Element elem, Twitter twitter) throws TwitterException {
        super(res);
        this.init(res, elem, twitter);
    }

    public Status(String str) throws TwitterException, JSONException {
        JSONObject json = new JSONObject(str);
        this.id = json.getLong("id");
        this.text = json.getString("text");
        this.source = json.getString("source");
        this.createdAt = Status.parseDate(json.getString("created_at"), "EEE MMM dd HH:mm:ss z yyyy");
        this.inReplyToStatusId = Status.getLong("in_reply_to_status_id", json);
        this.inReplyToUserId = Status.getInt("in_reply_to_user_id", json);
        this.isFavorited = Status.getBoolean("favorited", json);
        this.user = new User(json.getJSONObject("user"));
    }

    private void init(Response res, Element elem, Twitter twitter) throws TwitterException {
        NodeList retweetDetailsNode;
        Status.ensureRootNodeNameIs("status", elem);
        this.user = new User(res, (Element)elem.getElementsByTagName("user").item(0), twitter);
        this.id = Status.getChildLong("id", elem);
        this.text = Status.getChildText("text", elem);
        this.source = Status.getChildText("source", elem);
        this.createdAt = Status.getChildDate("created_at", elem);
        this.isTruncated = Status.getChildBoolean("truncated", elem);
        this.inReplyToStatusId = Status.getChildLong("in_reply_to_status_id", elem);
        this.inReplyToUserId = Status.getChildInt("in_reply_to_user_id", elem);
        this.isFavorited = Status.getChildBoolean("favorited", elem);
        this.inReplyToScreenName = Status.getChildText("in_reply_to_screen_name", elem);
        NodeList georssPoint = elem.getElementsByTagName("georss:point");
        if (1 == georssPoint.getLength()) {
            String[] point = georssPoint.item(0).getFirstChild().getNodeValue().split(" ");
            this.latitude = Double.parseDouble(point[0]);
            this.longitude = Double.parseDouble(point[1]);
        }
        if (1 == (retweetDetailsNode = elem.getElementsByTagName("retweet_details")).getLength()) {
            this.retweetDetails = new RetweetDetails(res, (Element)retweetDetailsNode.item(0), twitter);
        }
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public long getId() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public String getSource() {
        return this.source;
    }

    public boolean isTruncated() {
        return this.isTruncated;
    }

    public long getInReplyToStatusId() {
        return this.inReplyToStatusId;
    }

    public int getInReplyToUserId() {
        return this.inReplyToUserId;
    }

    public String getInReplyToScreenName() {
        return this.inReplyToScreenName;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public boolean isFavorited() {
        return this.isFavorited;
    }

    public User getUser() {
        return this.user;
    }

    public boolean isRetweet() {
        return null != this.retweetDetails;
    }

    public RetweetDetails getRetweetDetails() {
        return this.retweetDetails;
    }

    static List<Status> constructStatuses(Response res, Twitter twitter) throws TwitterException {
        Document doc = res.asDocument();
        if (Status.isRootNodeNilClasses(doc)) {
            return new ArrayList<Status>(0);
        }
        try {
            Status.ensureRootNodeNameIs("statuses", doc);
            NodeList list = doc.getDocumentElement().getElementsByTagName("status");
            int size = list.getLength();
            ArrayList<Status> statuses = new ArrayList<Status>(size);
            for (int i = 0; i < size; ++i) {
                Element status = (Element)list.item(i);
                statuses.add(new Status(res, status, twitter));
            }
            return statuses;
        }
        catch (TwitterException te) {
            Status.ensureRootNodeNameIs("nil-classes", doc);
            return new ArrayList<Status>(0);
        }
    }

    public int hashCode() {
        return (int)this.id;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return obj instanceof Status && ((Status)obj).id == this.id;
    }

    public String toString() {
        return new StringBuffer().append("Status{createdAt=").append(this.createdAt).append(", id=").append(this.id).append(", text='").append(this.text).append('\'').append(", source='").append(this.source).append('\'').append(", isTruncated=").append(this.isTruncated).append(", inReplyToStatusId=").append(this.inReplyToStatusId).append(", inReplyToUserId=").append(this.inReplyToUserId).append(", isFavorited=").append(this.isFavorited).append(", inReplyToScreenName='").append(this.inReplyToScreenName).append('\'').append(", latitude=").append(this.latitude).append(", longitude=").append(this.longitude).append(", retweetDetails=").append(this.retweetDetails).append(", user=").append(this.user).append('}').toString();
    }
}

