/*
 * Decompiled with CFR 0.152.
 */
package net.jadler;

import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.jadler.Request;
import net.jadler.RequestManager;
import net.jadler.exception.JadlerException;
import net.jadler.mocking.Mocker;
import net.jadler.mocking.Verifying;
import net.jadler.stubbing.HttpStub;
import net.jadler.stubbing.RequestStubbing;
import net.jadler.stubbing.StubResponse;
import net.jadler.stubbing.Stubber;
import net.jadler.stubbing.Stubbing;
import net.jadler.stubbing.StubbingFactory;
import net.jadler.stubbing.server.StubHttpServer;
import net.jadler.stubbing.server.StubHttpServerManager;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.lang.Validate;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadlerMocker
implements StubHttpServerManager,
Stubber,
RequestManager,
Mocker {
    private final StubHttpServer server;
    private final StubbingFactory stubbingFactory;
    private final List<Stubbing> stubbings;
    private Deque<HttpStub> httpStubs;
    private final Set<Request> receivedRequests;
    private MultiMap defaultHeaders;
    private int defaultStatus;
    private Charset defaultEncoding;
    private boolean started = false;
    private boolean configurable = true;
    private static final StubResponse NO_RULE_FOUND_RESPONSE = StubResponse.builder().status(404).body("No stub response found for the incoming request", Charset.forName("UTF-8")).header("Content-Type", "text/plain; charset=utf-8").build();
    private static final Logger logger = LoggerFactory.getLogger(JadlerMocker.class);

    public JadlerMocker(StubHttpServer server) {
        this(server, new StubbingFactory());
    }

    JadlerMocker(StubHttpServer server, StubbingFactory stubbingFactory) {
        Validate.notNull((Object)server, (String)"server cannot be null");
        this.server = server;
        this.stubbings = new LinkedList<Stubbing>();
        this.defaultHeaders = new MultiValueMap();
        this.defaultStatus = 200;
        this.defaultEncoding = Charset.forName("UTF-8");
        Validate.notNull((Object)stubbingFactory, (String)"stubbingFactory cannot be null");
        this.stubbingFactory = stubbingFactory;
        this.httpStubs = new LinkedList<HttpStub>();
        this.receivedRequests = new HashSet<Request>();
    }

    @Override
    public void start() {
        if (this.started) {
            throw new IllegalStateException("The stub server has been started already.");
        }
        logger.debug("starting the underlying stub server...");
        this.server.registerRequestManager(this);
        try {
            this.server.start();
        }
        catch (Exception ex) {
            throw new JadlerException("Stub http server start failure", ex);
        }
        this.started = true;
    }

    @Override
    public void close() {
        if (!this.started) {
            throw new IllegalStateException("The stub server hasn't been started yet.");
        }
        logger.debug("stopping the underlying stub server...");
        try {
            this.server.stop();
        }
        catch (Exception ex) {
            throw new JadlerException("Stub http server shutdown failure", ex);
        }
        this.started = false;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public int getStubHttpServerPort() {
        if (!this.started) {
            throw new IllegalStateException("The stub http server hasn't been started yet.");
        }
        return this.server.getPort();
    }

    public void addDefaultHeader(String name, String value) {
        Validate.notEmpty((String)name, (String)"header name cannot be empty");
        Validate.notNull((Object)value, (String)"header value cannot be null, use an empty string instead");
        this.checkConfigurable();
        this.defaultHeaders.put((Object)name, (Object)value);
    }

    public void setDefaultStatus(int defaultStatus) {
        Validate.isTrue((defaultStatus >= 0 ? 1 : 0) != 0, (String)"defaultStatus mustn't be negative");
        this.checkConfigurable();
        this.defaultStatus = defaultStatus;
    }

    public void setDefaultEncoding(Charset defaultEncoding) {
        Validate.notNull((Object)defaultEncoding, (String)"defaultEncoding cannot be null");
        this.checkConfigurable();
        this.defaultEncoding = defaultEncoding;
    }

    @Override
    public RequestStubbing onRequest() {
        logger.debug("adding new stubbing...");
        this.checkConfigurable();
        Stubbing stubbing = this.stubbingFactory.createStubbing(this.defaultEncoding, this.defaultStatus, this.defaultHeaders);
        this.stubbings.add(stubbing);
        return stubbing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StubResponse provideStubResponseFor(Request request) {
        JadlerMocker jadlerMocker = this;
        synchronized (jadlerMocker) {
            if (this.configurable) {
                this.configurable = false;
                this.httpStubs = this.createHttpStubs();
            }
            this.receivedRequests.add(request);
        }
        Iterator<HttpStub> it = this.httpStubs.descendingIterator();
        while (it.hasNext()) {
            HttpStub rule = it.next();
            if (!rule.matches(request)) continue;
            StringBuilder sb = new StringBuilder();
            sb.append("Following rule will be applied:\n");
            sb.append(rule);
            logger.debug(sb.toString());
            return rule.nextResponse(request);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("No suitable rule found. Reason:\n");
        for (HttpStub rule : this.httpStubs) {
            sb.append("The rule '");
            sb.append(rule);
            sb.append("' cannot be applied. Mismatch:\n");
            sb.append(rule.describeMismatch(request));
            sb.append("\n");
        }
        logger.info(sb.toString());
        return NO_RULE_FOUND_RESPONSE;
    }

    @Override
    public Verifying verifyThatRequest() {
        return new Verifying(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int numberOfRequestsMatching(Collection<Matcher<? super Request>> predicates) {
        Validate.notNull(predicates, (String)"predicates cannot be null");
        Matcher all = Matchers.allOf(predicates);
        int cnt = 0;
        JadlerMocker jadlerMocker = this;
        synchronized (jadlerMocker) {
            for (Request req : this.receivedRequests) {
                if (!all.matches((Object)req)) continue;
                ++cnt;
            }
        }
        return cnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        JadlerMocker jadlerMocker = this;
        synchronized (jadlerMocker) {
            this.stubbings.clear();
            this.httpStubs.clear();
            this.receivedRequests.clear();
            this.configurable = true;
        }
    }

    private Deque<HttpStub> createHttpStubs() {
        LinkedList<HttpStub> stubs = new LinkedList<HttpStub>();
        for (Stubbing stub : this.stubbings) {
            stubs.add(stub.createRule());
        }
        return stubs;
    }

    private synchronized void checkConfigurable() {
        if (!this.configurable) {
            throw new IllegalStateException("Once first http request has been served, you can't do any stubbing anymore.");
        }
    }
}

