/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.assertj;

import java.util.Comparator;
import java.util.List;
import net.javacrumbs.jsonunit.assertj.ExpectedNode;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.internal.Diff;
import net.javacrumbs.jsonunit.core.internal.JsonUtils;
import net.javacrumbs.jsonunit.core.internal.Node;
import net.javacrumbs.jsonunit.core.internal.Path;
import org.assertj.core.groups.Tuple;

class JsonComparator
implements Comparator<Object> {
    private final Configuration configuration;
    private final Path path;
    private final boolean actualParsed;

    JsonComparator(Configuration configuration, Path path, boolean actualParsed) {
        this.configuration = configuration;
        this.path = path;
        this.actualParsed = actualParsed;
    }

    @Override
    public int compare(Object actual, Object expected) {
        Object actual2;
        Diff diff;
        if (actual instanceof Tuple && expected instanceof Tuple) {
            return this.compareTuples((Tuple)actual, (Tuple)expected);
        }
        if (this.actualParsed && !(actual instanceof Node) && expected instanceof Node && !(expected instanceof ExpectedNode) || actual instanceof ExpectedNode) {
            Object tmp = actual;
            actual = expected;
            expected = tmp;
        }
        if ((diff = Diff.create((Object)expected, (Object)(actual2 = this.actualParsed ? JsonUtils.wrapDeserializedObject((Object)actual) : actual), (String)"", (Path)this.path, (Configuration)this.configuration)).similar()) {
            return 0;
        }
        return -1;
    }

    private int compareTuples(Tuple actual, Tuple expected) {
        List actualList = actual.toList();
        List expectedList = expected.toList();
        if (actualList.size() != expectedList.size()) {
            return -1;
        }
        for (int i = 0; i < actualList.size(); ++i) {
            int result = this.compare(actualList.get(i), expectedList.get(i));
            if (result == 0) continue;
            return result;
        }
        return 0;
    }
}

