/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.smock.common;

import java.io.IOException;
import java.net.URI;
import javax.xml.transform.Source;
import net.javacrumbs.smock.common.EnhancedDiff;
import net.javacrumbs.smock.common.SourceAndControlAssertionError;
import net.javacrumbs.smock.common.XmlUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.XMLUnit;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.test.client.RequestMatcher;
import org.springframework.ws.test.server.ResponseMatcher;

public class MessageMatcher
implements RequestMatcher,
ResponseMatcher {
    protected final Source controlMessage;
    private final Log logger = LogFactory.getLog(this.getClass());

    public MessageMatcher(Source controlMessage) {
        this.controlMessage = controlMessage;
    }

    protected final void matchInternal(WebServiceMessage input, WebServiceMessage message) {
        Source controlMessage = this.preprocessControlMessage(input);
        if (this.isSoapControl(controlMessage)) {
            Source messageSource = XmlUtil.getEnvelopeSource(message);
            this.compare(controlMessage, messageSource);
        } else {
            Source messageSource = message.getPayloadSource();
            this.compare(controlMessage, messageSource);
        }
    }

    public void match(WebServiceMessage request, WebServiceMessage response) throws IOException, AssertionError {
        this.matchInternal(request, response);
    }

    public void match(URI uri, WebServiceMessage request) throws IOException, AssertionError {
        this.matchInternal(null, request);
    }

    protected final void compare(Source controlMessage, Source messageSource) {
        Diff diff;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Comparing:\n " + XmlUtil.serialize(controlMessage) + "\n with:\n" + XmlUtil.serialize(messageSource)));
        }
        if (!(diff = this.createDiff(controlMessage, messageSource)).similar()) {
            throw new SourceAndControlAssertionError("Messages are different, " + diff.toString(), "Message", messageSource, "Control message", controlMessage);
        }
    }

    protected Source preprocessControlMessage(WebServiceMessage input) {
        return this.getControlMessage();
    }

    protected Diff createDiff(Source controlMessage, Source messageSource) {
        return new EnhancedDiff(XmlUtil.loadDocument(controlMessage), XmlUtil.loadDocument(messageSource));
    }

    private boolean isSoapControl(Source controlMessage) {
        return XmlUtil.isSoap(controlMessage);
    }

    public final Source getControlMessage() {
        return this.controlMessage;
    }

    static {
        XMLUnit.setIgnoreWhitespace((boolean)true);
    }
}

